﻿// home.js
(function () {
  "use strict";

  WinJS.UI.Pages.define("/pages/home/home.html", {
    ready: function (element, options) {
      pickContactsButton.onclick = pickContactsButton_click;
    }
  });

  function pickContactsButton_click() {
      
    // utwórz selektor
    var contacts = Windows.ApplicationModel.Contacts;
    var picker = new contacts.ContactPicker();

    // potrzebujemy całego kontaktu (domyślnie)
    //picker.selectionMode = contacts.ContactSelectionMode.contacts;

    // potrzebujemy tylko kontaktów z numerami telefonów
    //picker.selectionMode = contacts.ContactSelectionMode.fields;
    //picker.desiredFields.append(contacts.KnownContactField.email);

    // Pobierz pojedynczy kontakt
    //picker.pickSingleContactAsync().done(function (contact) {
    //  output.innerHTML = "";
    //  if (contact) { outputContactNameAndEmail(contact); }
    //  //if (contact) { outputContact(contact); }
    //});

    // pobierz wiele kontaktów
    picker.pickMultipleContactsAsync().done(function (contacts) {
      output.innerHTML = "";
      if (contacts.length) {
        contacts.forEach(function (contact) {
          outputContactNameAndEmail(contact);
        });
      }
    });
  }

  function outputContactNameAndEmail(contact) {
    output.innerHTML += "<h2>Nazwa= " + contact.name + "</h2>";

    output.innerHTML += "<p>Adresy email:</p><ul>";
    contact.emails.forEach(function (email) {
      output.innerHTML += "<li>" + email.value + "</li>";
    });
    output.innerHTML += "</ul>";
  }

  function dumpObject(obj) {
    var s = "";
    for (var key in obj) {
      s += key + "= " + obj[key] + ", ";
    }
    return s;
  }

  function outputContact(contact) {
    // Nazwa
    output.innerHTML += "<h2>Nazwa= " + contact.name + "</h2>";

    // Adres e-mail
    output.innerHTML += "<p>Adresy email:</p><ul>";
    contact.emails.forEach(function (email) {
      output.innerHTML += "<li>" + dumpObject(email) + "</li>";
    });
    output.innerHTML += "</ul>";

    // Błyskawiczne wiadomości
    output.innerHTML += "<p>Błyskawiczne wiadomości:</p><ul>";
    contact.instantMessages.forEach(function (instantMessage) {
      output.innerHTML += "<li>" + dumpObject(instantMessage) + "</li>";
    });
    output.innerHTML += "</ul>";

    // Lokalizacje
    output.innerHTML += "<p>Lokalizacje:</p><ul>";
    contact.locations.forEach(function (location) {
      output.innerHTML += "<li>" + dumpObject(location) + "</li>";
    });
    output.innerHTML += "</ul>";

    // Numery telefonów
    output.innerHTML += "<p>Numery telefonów:</p><ul>";
    contact.phoneNumbers.forEach(function (phoneNumber) {
      output.innerHTML += "<li>" + dumpObject(phoneNumber) + "</li>";
    });
    output.innerHTML += "</ul>";
  }

})();
