﻿(function () {
    "use strict";

    // Ta funkcja jest wywoływana, gdy użytkownik przechodzi do tej strony. To
    // wypełnia elementy strona danymi aplikacji.
    function ready(element, options) {
        // pobranie kanałów
        this.feed = options.feed;
        var pageTitle = element.querySelector(".pagetitle");
        pageTitle.innerText = this.feed.title;

        this.section = document.querySelector("section[role=main]");
        this.section.innerHTML = "<p>pobieranie...</p>";

        // pobranie przy wykorzystaniu WinRT
        var syn = new Windows.Web.Syndication.SyndicationClient();
        var url = new Windows.Foundation.Uri(this.feed.url);
        syn.retrieveFeedAsync(url).done(processPosts.bind(this), downloadError.bind(this));
    }

    // przetwarzanie przy wykorzystaniu WinRT
    function processPosts(request) {
        // usunięcie wskaźnika postępu
        this.section.innerHTML = "";

        // iteracja po elementach
        for (var i = 0, len = request.items.length; i < len; i++) {
            var item = request.items[i];
            var parent = document.createElement("div");
            appendDiv(parent, item.title.text, "postTitle");
            appendDiv(parent, item.publishedDate, "postDate");
            appendDiv(parent, item.summary.text, "postContent");
            this.section.appendChild(parent);
        }
    }

    function appendDiv(parent, html, className) {
        var div = document.createElement("div");
        div.innerHTML = toStaticHTML(html);
        div.className = className;
        parent.appendChild(div);
    }

    function downloadError(feed) {
        this.section.innerHTML = "<p>błąd</p>";
    }

    WinJS.UI.Pages.define("/pages/posts/posts.html", {
        ready: ready,
    });
})();
