﻿// shareTarget.js
(function () {
  "use strict";

  var app = WinJS.Application;
  var share;

  function onShareSubmit() {
    document.querySelector(".progressindicators").style.visibility = "visible";
    document.querySelector(".commentbox").disabled = true;
    document.querySelector(".submitbutton").disabled = true;

    // TODO: Zrób coś z udostępnionymi danymi przechowywanymi w zmiennej "share".

    share.reportCompleted();
  }

  // Ta funkcja odpowiada wszystkim aktywacjom aplikacji.
  app.onactivated = function (args) {
    var thumbnail;

    if (args.detail.kind === Windows.ApplicationModel.Activation.ActivationKind.shareTarget) {
      document.querySelector(".submitbutton").onclick = onShareSubmit;
      share = args.detail.shareOperation;

      document.querySelector(".shared-title").textContent = share.data.properties.title;
      document.querySelector(".shared-description").textContent = share.data.properties.description;

      thumbnail = share.data.properties.thumbnail;
      if (thumbnail) {
        // Jeśli udostępniane dane zawierają miniaturę, wyświetl ją.
        args.setPromise(thumbnail.openReadAsync().done(function displayThumbnail(stream) {
          document.querySelector(".shared-thumbnail").src = window.URL.createObjectURL(stream);
        }));
      }
      else {
        // Jeśli nie ma miniatury, rozwiń elementy: opis i
        // tytuł, aby wypełnić nieużywane miejsce.
        document.querySelector("section[role=main] header").style.setProperty("-ms-grid-columns", "0px 0px 1fr");
        document.querySelector(".shared-thumbnail").style.visibility = "hidden";
      }

      // pokaż udostępniane dane
      var data = share.data;
      var found = false;

      var dataFormats = Windows.ApplicationModel.DataTransfer.StandardDataFormats;
      if (data.contains(dataFormats.text)) {
        found = true;
        data.getTextAsync().done(function (text) {
          document.querySelector(".shared-text").innerText = "Udostępniony tekst: " + text;
        });
      }

      if (data.contains(dataFormats.html)) {
        found = true;
        data.getHtmlFormatAsync().done(function (html) {
          // pobierz fragment z obiektu HTMLFormat
          var fragment = Windows.ApplicationModel.DataTransfer.HtmlFormatHelper.getStaticFragment(html);
          document.querySelector(".shared-html").innerText = "Udostępniony HTML: " + fragment;
        });
      }

      if (data.contains(dataFormats.rtf)) {
        found = true;
        data.getRtfAsync().done(function (rtf) {
          document.querySelector(".shared-rtf").innerText = "Udostępniony RTF: " + rtf;
        });
      }

      if (data.contains(dataFormats.uri)) {
        found = true;
        data.getUriAsync().done(function (uri) {
          document.querySelector(".shared-uri").innerText = "Udostępniony URI: " + uri.absoluteUri;
        });
      }

      if (data.contains(dataFormats.bitmap)) {
        found = true;
        // powiadom powłokę, że operacja może chwilę potrwać
        share.reportStarted();
        share.data.getBitmapAsync().
          then(function (streamRef) {
            // pobierz bitmapę ze strumienia
            return streamRef.openReadAsync();
          }).
          done(function (stream) {
            // powiadom powłokę, że mamy dane
            share.reportDataRetrieved();

            var uri = URL.createObjectURL(stream);
            document.querySelector(".shared-text").innerText = "Udostępniona bitmapa:";
            document.querySelector(".shared-bitmap").src = uri;
            document.querySelector(".shared-bitmap").style.visibility = "visible";
          });
      }

      if (data.contains(dataFormats.storageItems)) {
        found = true;
        // powiadom powłokę, że operacja może chwilę potrwać
        share.reportStarted();
        data.getStorageItemsAsync().
          then(function (items) {
            // załaduj bitmapę z pliku
            var streams = Windows.Storage.Streams;
            var image = items.getAt(0); // pobieramy tylko pierwszy obraz
            var streamRef = streams.RandomAccessStreamReference.createFromFile(image);
            return streamRef.openReadAsync();
          }).
          done(function (stream) {
            // powiadom powłokę, że mamy dane
            share.reportDataRetrieved();

            var uri = URL.createObjectURL(stream);
            document.querySelector(".shared-text").innerText = "Udostępniony plik obrazu:";
            document.querySelector(".shared-storage-item-bitmap").src = uri;
            document.querySelector(".shared-storage-item-bitmap").style.visibility = "visible";
          });
      }

      if (!found) {
        share.reportError("Brak znanych formatów danych");
      }

    }
  };

  app.start();
})();
