﻿// data.js
(function () {
  "use strict";

  var groupDescription = "Group Description: Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus tempor scelerisque lorem in vehicula. Aliquam tincidunt, lacus ut sagittis tristique, turpis massa volutpat augue, eu rutrum ligula ante a ante";
  var itemDescription = "Item Description: Pellentesque porta mauris quis interdum vehicula urna sapien ultrices velit nec venenatis dui odio in augue cras posuere enim a cursus convallis neque turpis malesuada erat ut adipiscing neque tortor ac erat";
  var itemContent = "<p>Curabitur class aliquam vestibulum nam curae maecenas sed integer cras phasellus suspendisse quisque donec dis praesent accumsan bibendum pellentesque condimentum adipiscing etiam consequat vivamus dictumst aliquam duis convallis scelerisque est parturient ullamcorper aliquet fusce suspendisse nunc hac eleifend amet blandit facilisi condimentum commodo scelerisque faucibus aenean ullamcorper ante mauris dignissim consectetuer nullam lorem vestibulum habitant conubia elementum pellentesque morbi facilisis arcu sollicitudin diam cubilia aptent vestibulum auctor eget dapibus pellentesque inceptos leo egestas interdum nulla consectetuer suspendisse adipiscing pellentesque proin lobortis sollicitudin augue elit mus congue fermentum parturient fringilla euismod feugiat</p><p>Curabitur class aliquam vestibulum nam curae maecenas sed integer cras phasellus suspendisse quisque donec dis praesent accumsan bibendum pellentesque condimentum adipiscing etiam consequat vivamus dictumst aliquam duis convallis scelerisque est parturient ullamcorper aliquet fusce suspendisse nunc hac eleifend amet blandit facilisi condimentum commodo scelerisque faucibus aenean ullamcorper ante mauris dignissim consectetuer nullam lorem vestibulum habitant conubia elementum pellentesque morbi facilisis arcu sollicitudin diam cubilia aptent vestibulum auctor eget dapibus pellentesque inceptos leo egestas interdum nulla consectetuer suspendisse adipiscing pellentesque proin lobortis sollicitudin augue elit mus congue fermentum parturient fringilla euismod feugiat</p><p>Curabitur class aliquam vestibulum nam curae maecenas sed integer cras phasellus suspendisse quisque donec dis praesent accumsan bibendum pellentesque condimentum adipiscing etiam consequat vivamus dictumst aliquam duis convallis scelerisque est parturient ullamcorper aliquet fusce suspendisse nunc hac eleifend amet blandit facilisi condimentum commodo scelerisque faucibus aenean ullamcorper ante mauris dignissim consectetuer nullam lorem vestibulum habitant conubia elementum pellentesque morbi facilisis arcu sollicitudin diam cubilia aptent vestibulum auctor eget dapibus pellentesque inceptos leo egestas interdum nulla consectetuer suspendisse adipiscing pellentesque proin lobortis sollicitudin augue elit mus congue fermentum parturient fringilla euismod feugiat</p><p>Curabitur class aliquam vestibulum nam curae maecenas sed integer cras phasellus suspendisse quisque donec dis praesent accumsan bibendum pellentesque condimentum adipiscing etiam consequat vivamus dictumst aliquam duis convallis scelerisque est parturient ullamcorper aliquet fusce suspendisse nunc hac eleifend amet blandit facilisi condimentum commodo scelerisque faucibus aenean ullamcorper ante mauris dignissim consectetuer nullam lorem vestibulum habitant conubia elementum pellentesque morbi facilisis arcu sollicitudin diam cubilia aptent vestibulum auctor eget dapibus pellentesque inceptos leo egestas interdum nulla consectetuer suspendisse adipiscing pellentesque proin lobortis sollicitudin augue elit mus congue fermentum parturient fringilla euismod feugiat</p><p>Curabitur class aliquam vestibulum nam curae maecenas sed integer cras phasellus suspendisse quisque donec dis praesent accumsan bibendum pellentesque condimentum adipiscing etiam consequat vivamus dictumst aliquam duis convallis scelerisque est parturient ullamcorper aliquet fusce suspendisse nunc hac eleifend amet blandit facilisi condimentum commodo scelerisque faucibus aenean ullamcorper ante mauris dignissim consectetuer nullam lorem vestibulum habitant conubia elementum pellentesque morbi facilisis arcu sollicitudin diam cubilia aptent vestibulum auctor eget dapibus pellentesque inceptos leo egestas interdum nulla consectetuer suspendisse adipiscing pellentesque proin lobortis sollicitudin augue elit mus congue fermentum parturient fringilla euismod feugiat</p><p>Curabitur class aliquam vestibulum nam curae maecenas sed integer cras phasellus suspendisse quisque donec dis praesent accumsan bibendum pellentesque condimentum adipiscing etiam consequat vivamus dictumst aliquam duis convallis scelerisque est parturient ullamcorper aliquet fusce suspendisse nunc hac eleifend amet blandit facilisi condimentum commodo scelerisque faucibus aenean ullamcorper ante mauris dignissim consectetuer nullam lorem vestibulum habitant conubia elementum pellentesque morbi facilisis arcu sollicitudin diam cubilia aptent vestibulum auctor eget dapibus pellentesque inceptos leo egestas interdum nulla consectetuer suspendisse adipiscing pellentesque proin lobortis sollicitudin augue elit mus congue fermentum parturient fringilla euismod feugiat</p><p>Curabitur class aliquam vestibulum nam curae maecenas sed integer cras phasellus suspendisse quisque donec dis praesent accumsan bibendum pellentesque condimentum adipiscing etiam consequat vivamus dictumst aliquam duis convallis scelerisque est parturient ullamcorper aliquet fusce suspendisse nunc hac eleifend amet blandit facilisi condimentum commodo scelerisque faucibus aenean ullamcorper ante mauris dignissim consectetuer nullam lorem vestibulum habitant conubia elementum pellentesque morbi facilisis arcu sollicitudin diam cubilia aptent vestibulum auctor eget dapibus pellentesque inceptos leo egestas interdum nulla consectetuer suspendisse adipiscing pellentesque proin lobortis sollicitudin augue elit mus congue fermentum parturient fringilla euismod feugiat";

  // To są obrazy zakodowane jako ciągi znaków. Musisz ustawić właściwość
  // backgroundImage na adresy URL rzeczywistych obrazów tła
  var lightGray = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXY7h4+cp/AAhpA3h+ANDKAAAAAElFTkSuQmCC";
  var mediumGray = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXY5g8dcZ/AAY/AsAlWFQ+AAAAAElFTkSuQmCC";
  var darkGray = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXY3B0cPoPAANMAcOba1BlAAAAAElFTkSuQmCC";

  // utwórz referencję StreamReference do logo z magazynu aplikacji
  var streams = Windows.Storage.Streams;
  var uri = new Windows.Foundation.Uri("ms-appx:///images/storelogo.png");
  var appIconStreamReference = streams.RandomAccessStreamReference.createFromUri(uri);



  // Pobierz odwołanie do elementu używając klucza grupy i tytułu elementu
  // jako unikalnych identyfikatorów elementu, który może być łatwo serializowany
  function getItemReference(item) {
    return [item.group.key, item.title];
  }

  function resolveGroupReference(key) {
    for (var i = 0; i < groupedItems.groups.length; i++) {
      if (groupedItems.groups.getAt(i).key === key) {
        return groupedItems.groups.getAt(i);
      }
    }
  }

  function resolveItemReference(reference) {
    for (var i = 0; i < groupedItems.length; i++) {
      var item = groupedItems.getAt(i);
      if (item.id === reference) {
        return item;
      }
    }
  }

  function getSuggestedResults(queries, maxSuggestions) {
    var results = [];

    // Nie mamy jeszcze żadnych elementów, więc nie sugerujemy niczego (tylko wracamy)
    if (groupedItems || groupedItems.length > 0) {

      // Utworzenie sugestii
      var suggestionList = [];
      groupedItems.forEach(function (i) {
        suggestionList.push(i);
      });

      // Test każdego zapytania i alternatyw
      queries.forEach(function (q) {

        var atMax = false;

        // Przejście przez każdą sugestię
        suggestionList.forEach(function (suggestion) {

          // Test sprawdzający, czy tytuł odpowiada zapytaniu (zapytaniom)
          var searchExpression = new RegExp(q, "i");
          if (searchExpression.test(suggestion.title)) {

            // Dodanie do listy sugestii
            results.push(suggestion);

            // Jeżeli osiągnięta została maksymalna liczba sugestii, przerywany test
            if (results.length >= maxSuggestions) {
              atMax = true;
              return false;
            }
          }
        });

        // Koniec, jeżeli osiągnęliśmy maksimum
        if (atMax) return;
      });
    }
    console.log("Suggested: " + results.length);
    return results;
  }

  // Wyszukaj grupę po tytule
  function resolveGroupByName(title) {
    for (var x = 0; x < groupedItems.groups.length; x++) {
      var group = groupedItems.groups[x];
      if (group.title === title) return group;
    }
  }

  // Ta funkcja zwraca obiekt WinJS.Binding.List zawierający tylko elementy
  // należące do wskazanej grupy.
  function getItemsFromGroup(group) {
    return list.createFiltered(function (item) { return item.group.key === group.key; });
  }

  var list = new WinJS.Binding.List();
  var groupedItems = list.createGrouped(
      function groupKeySelector(item) { return item.group.key; },
      function groupDataSelector(item) { return item.group; }
  );

  // Wartości domyślne i pamięć podręczna ustawień
  var showNotifications = true;
  var feeds = [
    { key: "feed1", title: "Brandon Satrom", subtitle: "blog", backgroundImage: darkGray, description: "blog", url: "http://feeds.feedburner.com/userinexperience/tYGT", enabled: true },
    { key: "feed2", title: "Chris Sells", subtitle: "blog", backgroundImage: lightGray, description: "blog", url: "http://sellsbrothers.com/posts/?format=rss", enabled: true },
    { key: "feed3", title: "Channel 9", subtitle: "blog", backgroundImage: mediumGray, description: "blog", url: "http://channel9.msdn.com/Feeds/RSS", enabled: true },
  ];

  var settings = Windows.Storage.ApplicationData.current.localSettings.values;
  if (settings.hasKey("feeds")) { feeds = JSON.parse(settings.feeds); }
  if (settings.hasKey("showNotifications")) { showNotifications = settings.showNotifications; }

  // przetwarzaj wszystkie kanały przy uruchomieniu aplikacji
  feeds.forEach(processFeed);

  // przetwarzaj każdy kanał jeżeli trzeba
  function processFeed(feed) {
    // usuń listę elementów z tego kanału
    if (resolveGroupReference(feed.key)) {
      for (var i = list.length - 1; i >= 0; i--) {
        if (list.getAt(i).group.key == feed.key) {
          list.splice(i, 1);
        }
      }
    }

    // pobierz kanał
    if (feed.enabled) {
      var syn = new Windows.Web.Syndication.SyndicationClient();
      var url = new Windows.Foundation.Uri(feed.url);
      syn.retrieveFeedAsync(url).done(processPosts.bind(feed));
    }
  }

  // przetwarzaj pobrane elementy
  function processPosts(request) {
    var feed = this;
    request.items.forEach(function (item) {
      var post = {
        group: feed,
        title: item.title.text,
        subtitle: item.publishedDate,
        description: "post",
        content: toStaticHTML(item.summary.text),
        backgroundImage: feed.backgroundImage,
        id: item.id // do wyszukiwania elementu
      };

      // powiadom listę o każdej wiadomości
      list.push(post);
    });
  }

  function findFeed(key) {
    return feeds.filter(function (feed) { return feed.key == key; })[0];
  }

  function getSetting(name) {
    switch (name) {
      case "feed1enabled":
      case "feed2enabled":
      case "feed3enabled":
        return findFeed(name.substr(0, 5)).enabled;
        break;

      case "showNotifications":
        return showNotifications;
        break;
    }
  }

  function setSetting(name, value) {
    switch (name) {
      case "feed1enabled":
      case "feed2enabled":
      case "feed3enabled":
        var feed = findFeed(name.substr(0, 5));
        if (feed.enabled == value) { return; }
        feed.enabled = value;
        settings.feeds = JSON.stringify(feeds);
        processFeed(feed);
        break;

      case "showNotifications":
        if (showNotifications == value) { return; }
        showNotifications = value;
        settings.showNotifications = showNotifications;
        break;
    }
  }

  WinJS.Namespace.define("Data", {
    items: groupedItems,
    groups: groupedItems.groups,
    getItemsFromGroup: getItemsFromGroup,
    getItemReference: getItemReference,
    resolveGroupReference: resolveGroupReference,
    resolveItemReference: resolveItemReference,
    getSetting: getSetting, // pobierz bieżące ustawienie
    setSetting: setSetting, // wpisz nowe ustawienia
    getSuggestedResults: getSuggestedResults, // dla sugestii wyszukiwania
    resolveGroupByName: resolveGroupByName, // wyszukaj grupę po nazwie (nie kluczu)
    appIconStreamReference: appIconStreamReference, // strumień zawierający ikonę aplikacji
  });
})();
