﻿(function () {
  "use strict";

  var list = new WinJS.Binding.List();
  var groupedItems = list.createGrouped(
      function groupKeySelector(item) { return item.group.key; },
      function groupDataSelector(item) { return item.group; }
  );

  var darkGray = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXY3B0cPoPAANMAcOba1BlAAAAAElFTkSuQmCC";
  var lightGray = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXY7h4+cp/AAhpA3h+ANDKAAAAAElFTkSuQmCC";
  var mediumGray = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAANSURBVBhXY5g8dcZ/AAY/AsAlWFQ+AAAAAElFTkSuQmCC";

  var searches = [
        { key: "group1", title: "Brandon Satrom", subtitle: "pictures", backgroundImage: darkGray, description: "Brandon Satrom images" },
        { key: "group2", title: "Chris Sells", subtitle: "pictures", backgroundImage: lightGray, description: "Chris Sells images" },
        { key: "group3", title: "kitties", subtitle: "pictures", backgroundImage: mediumGray, description: "kitty images" },
  ];

  searches.forEach(function (search) {
    var q = "https://api.datamarket.azure.com/Data.ashx/Bing/Search/v1/Image?Query=%27" +
            search.title + "%27&$top=12&$format=json";
    var user = "csells@sellsbrothers.com";
    var pw = "TODO"; // pobierz klucz Bing Search API: http://bing.com/developers/

    WinJS.xhr({ url: q, user: user, password: pw }).done(function (request) {
      // analiza wyników JSON
      var response = JSON.parse(request.responseText);
      var items = response.d.results;
      items.forEach(function (item) {
        // utworzenie obrazu dla każdego elementu
        var image = {
          group: search,
          title: item.Title,
          subtitle: "",
          description: "image",
          content: "",
          backgroundImage: item.MediaUrl,
        };

        // powiadomienie listy o każdej wiadomości
        list.push(image);
      });
    });
  });

  WinJS.Namespace.define("Data", {
    items: groupedItems,
    groups: groupedItems.groups,
    getItemReference: getItemReference,
    getItemsFromGroup: getItemsFromGroup,
    resolveGroupReference: resolveGroupReference,
    resolveItemReference: resolveItemReference
  });

  // Pobierz odwołanie do elementu używając klucza grupy i tytułu elementu
  // jako unikalnych identyfikatorów elementu, który może być łatwo serializowany
  function getItemReference(item) {
    return [item.group.key, item.title];
  }

  // Ta funkcja zwraca obiekt WinJS.Binding.List zawierający tylko elementy
  // należące do wskazanej grupy
  function getItemsFromGroup(group) {
    return list.createFiltered(function (item) { return item.group.key === group.key; });
  }

  // Pobierz unikaną grupę odpowiadającą zadanemu kluczowi grupy.
  function resolveGroupReference(key) {
    for (var i = 0; i < groupedItems.groups.length; i++) {
      if (groupedItems.groups.getAt(i).key === key) {
        return groupedItems.groups.getAt(i);
      }
    }
  }

  // Pobierz unikalny element z zadanej tabeli ciągów znaków,
  // który powinien zawierać klucz grupy i tytuł elementu.
  function resolveItemReference(reference) {
    for (var i = 0; i < groupedItems.length; i++) {
      var item = groupedItems.getAt(i);
      if (item.group.key === reference[0] && item.title === reference[1]) {
        return item;
      }
    }
  }

})();
