﻿(function () {
    "use strict";
		
    var images = new WinJS.Binding.List([
			{ url: "images/BostonCityFlow.jpg", caption: "Niezwykłe zdjęcia z Bostonu", category: "Miasta" },
			{ url: "images/Chrysanthemum.jpg", caption: "Ulubione kwiaty Chris'a", category: "Kwiaty" },
			{ url: "images/Penguins.jpg", caption: "Pingwiny rozmawiają o Windows 8", category: "Zwierzęta" },
			{ url: "images/PensiveParakeet.jpg", caption: "Bobby Fischer na szachowych mistrzostwach ptaków", category: "Zwierzęta" },
			{ url: "images/CostaRicanFrog.jpg", caption: "Żaba spotkana na Costa Rica", category: "Zwierzęta" },
			{ url: "images/Jellyfish.jpg", caption: "Czyż meduza nie jest fajna?", category: "Zwierzęta" },
			{ url: "images/Hydrangeas.jpg", caption: "Ulubione kwiaty Brandona", category: "Kwiaty" },
			{ url: "images/Koala.jpg", caption: "Cześć!", category: "Zwierzęta" }
    ]);

    var groupedImages = images.createGrouped(getKey, getData, sorter);

    function getKey(item) {
      return item.category;
    }

    function getData(item) {
      return {
        title: item.category
      }
    }

    function sorter(leftItem, rightItem) {
      return leftItem.charCodeAt(0) - rightItem.charCodeAt(0);
    }

    WinJS.Namespace.define('Photos', {
      imageList: images,
      groupedImages: groupedImages
    });

    var app = WinJS.Application;

    app.onactivated = function (eventObject) {
        WinJS.UI.processAll();
    };

    app.start();
})();
