﻿(function () {
    "use strict";

    // globalna lista bindowania
    window.items = new WinJS.Binding.List();

    var people = new WinJS.Binding.List([
        { name: "Jasiek", age: 18, favoriteColor: "czerwony" },
        { name: "Tomek", age: 16, favoriteColor: "zielony" },
        { name: "Krzysiek", age: 42, favoriteColor: "niebieski" },
    ]);

    // sortowanie po imieniu
    window.sortedPeople = people.
        createSorted(function (lhs, rhs) {
            return lhs.name.localeCompare(rhs.name);
        });

    // filtrowanie po wieku (tylko dorośli)
    window.filteredPeople = people.
          createFiltered(function (p) { return p.age > 17; });

    // zmiany w danych są odzwierciedlone w widokach
    var person = { name: "Piotrek", age: 17, favoriteColor: "black" };
    people.push(person);

    // filtrowanie po wieku (nieletni) i sortowanie po imieniu
    window.filteredSortedPeople = people.
          createFiltered(function (p) { return p.age < 18; }).
          createSorted(function (lhs, rhs) { return lhs.name.localeCompare(rhs.name); });

    // grupowanie po wieku
    //window.groupedPeople = people.
    //  createGrouped(function (p) { return p.age < 18 ? "nieletni" : "dorosły" });
    function groupKeySelector(p) { return p.age < 18 ? "nieletni" : "dorosły"; };
    function groupDataSelector(p) { return p.age < 18 ? "nieletni" : "dorosły"; };
    window.groupedPeople = people.createGrouped(groupKeySelector, groupDataSelector);

    // filtrowanie po wieku (nieletni) i sortowanie po imieniu
    window.groupedSortedPeople = people.
          createGrouped(function (p) { return p.age < 18 ? "nieletni" : "adult"; }).
          createSorted(function (lhs, rhs) { return -lhs.name.localeCompare(rhs.name); });

    // sortowanie po imieniu i grupowanie po wieku
    window.sortedGroupedPeople = people.
          createSorted(function (lhs, rhs) { return -lhs.name.localeCompare(rhs.name); }).
          createGrouped(function (p) { return p.age < 18 ? "nieletni" : "adult" });

    (function () {
        // wyszukane grupowanie po wieku
        var groups = [{ key: 1, name: "Minor" }, { key: 2, name: "Adult" }];
        function groupKeySelector(p) { return p.age < 18 ? groups[0].key : groups[1].key; };
        function groupDataSelector(p) { return p.age < 18 ? groups[0] : groups[1]; };
        window.fancyGroupedPeople = people.createGrouped(groupKeySelector, groupDataSelector);
    })();


    WinJS.UI.Pages.define("/pages/home/home.html", {
        ready: function (element, options) {
            // lista bindowania rozciągnięta w czasie
            [0, 1, 2].forEach(function (i) {
                WinJS.Promise.timeout(500 * (i + 1)).done(function () {
                    // dodanie elementu do listy bindowania, aktualizacja ListView
                    items.push(i);
                });
            });

            // manualne renderowanie szablonu
            var template = itemTemplate.winControl;
            template.render(person).
              done(function (element) { peteDiv.appendChild(element); });

            (function () {
                // wykorzystanie wbudowanej tablicy
                var array = [];
                array.push("jeden");
                array.push("dwa");
                array.push("trzy");

                var x = array[0]; // x = "jeden"
                var y = array[1]; // y = "dwa"

                array[2] = "TRZY";
                var z = array[2]; // z = "TRZY";
            })();

            (function () {
                // wykorzystanie listy bindowania WinJS 
                var list = new WinJS.Binding.List();
                list.push("jeden");
                list.push("dwa");
                list.push("trzy");

                var x = list.getAt(0); // x = "jeden"
                var y = list.getAt(1); // y = "dwa"

                list.setAt(2, "TRZY");
                var z = list.getAt(2); // z = "TRZY";
            })();
        }
    });
})();
