// arrays.js

// dodanie do siebie elementw, nastpnie podzielenie
// sumy przez liczb elementw.
function avg(arrObj) {
	var sum = 0;
	for (var i = 0; i < arrObj.length; i++) {
		sum += arrObj[i];
		}
	return (sum / i);
	}

// Przegldanie kolejnych elementw, z ktrych
// zwracany jest najwikszy.
function high(arrObj) {
	var highest = arrObj[0];
	for (var i = 1; i < arrObj.length; i++) {
		highest = (arrObj[i] > highest ? arrObj[i] : highest);
		}
	return (highest);	
	}

// Przegldanie kolejnych elementw, z ktrych
// zwracany jest najmniejszy.
function low(arrObj) {
	var lowest = arrObj[0];
	for (var i = 1; i < arrObj.length; i++) {
		lowest = (arrObj[i] < lowest ? arrObj[i] : lowest);
		}
	return (lowest);	
	}

// Przegldanie kolejnych elementw i podmiana tekstu
// we wszystkich.
function jsGrep(arrObj, regexp, subStr) {
	for (var i = 0; i < arrObj.length; i++) {
		arrObj[i] = arrObj[i].replace(regexp, subStr);
		}
	return arrObj;
	}

// Funkcja ta zwraca kopi obiektu tablica bez ostatniego elementu.
function truncate(arrObj) {
	arrObj.length = arrObj.length - 1;
	return arrObj;
	}


// Funkcja zwraca kopi obiektu tablica bez pierwszego elementu.
function shrink(arrObj) {
	var tempArray = new Array(); 
	for(var p = 1; p < arrObj.length; p++) {
		tempArray[p - 1] = arrObj[p];
		}
	return tempArray;
	}


// Funkcja zwraca kopi obiektu tablica z elementami innej tablicy
// wstawionymi od wskazanego indeksu poczynajc.
function integrate(arrObj, elemArray, startIndex) {
	startIndex = (parseInt(Math.abs(startIndex)) < arrObj.length ? parseInt(Math.abs(startIndex)) : arrObj.length);
	var tempArray = new Array(); 
	for( var p = 0; p < startIndex; p++) {
		tempArray[p] = arrObj[p];
		}
	for( var q = startIndex; q < startIndex + elemArray.length; q++) {
		tempArray[q] = elemArray[q - startIndex];
		}
	for( var r = startIndex + elemArray.length; r < (arrObj.length + elemArray.length); r++) {
		tempArray[r] = arrObj[r - elemArray.length];
		}
	return tempArray;
	}

// Funkcja zwraca tablic z elementami uporzdkowanymi co ktry,
// przy czym krotnoci domyln jest 1.
function reorganize(formObj, stepUp) {
	stepUp = (Math.abs(parseInt(stepUp)) > 0 ? Math.abs(parseInt(stepUp)) : 1);
	var nextRound = 1;
	var idx = 0;
	var tempArray = new Array();

	for (var i = 0; i < formObj.length; i++) {
		tempArray[i] = formObj[idx];
		if (idx + stepUp >= formObj.length) {
			idx = nextRound;
			nextRound++;
			}
		else {
			idx += stepUp;
			}
		}
	return tempArray;
	}
