package structure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Program pokazuje użycie klasy HashMap i interfejsu Iterator, ze współbieżnym usuwaniem elementów.
 */
public class HashMapWithRemoves {

	public static void main(String[] argv) {
		// tag::main[]

        // Tworzymy i wypełniamy tablicę mieszającą. 
        // Symulujemy w ten sposób pobranie danych z bazy
        // lub z pliku, albo z dowolnego innego miejsca, 
        // w którym są one zapisane.

		Map<String,String> map = new HashMap<String,String>();

        // Tablica kojarzy nazwy firm z ich adresami.
        // W normalnym programie nazwy firmy mogłyby 
        // zostać skojarzone z jakimiś niestandardowymi 
        // obiektami Address.
		map.put("Adobe", "Mountain View, CA");
		map.put("IBM", "White Plains, NY");
		map.put("Learning Tree", "Los Angeles, CA");
		map.put("Microsoft", "Redmond, WA");
		map.put("Netscape", "Mountain View, CA");
		map.put("O'Reilly", "Sebastopol, CA");
		map.put("Sun", "Mountain View, CA");

		// tag::SafeRemoval[]
        // Sposób 2.: pobieramy wszystkie klucze i skojarzone z nimi
        // wartości (wraz ze współbieżnie wprowadzanymi modyfikacjami).
		Iterator<String> it = map.keySet().iterator();
		while (it.hasNext()) {
			String key = it.next();
			if (key.equals("Sun") || key.equals("Netscape")) {
				it.remove();
				continue;
			}
            System.out.println("Firma " + key + "; " +
                "adres " + map.get(key));
		}
		// end::SafeRemoval[]

		// tag::functional[]
		// Alternatywny sposób usuwania, bez stosowania pętli.
		map.keySet().removeIf(key -> Set.of("Netscape", "Sun").contains(key));
		// lub
		map .entrySet()
			.removeIf(entry -> Set.of("Netscape", "Sun")
			.contains(entry.getKey()));
		map.entrySet().forEach(System.out::println);
		// end::functional[]
		// end::main[]
	}
}
