import java.io.*;
import java.nio.file.*;
import java.util.regex.*;

public class ReaderIter {
    public static void main(String[] args) throws IOException {
        // Wzorzec.
        Pattern patt = Pattern.compile("[A-Za-z][a-z]+");
        // Patrz rozdział o operacjach wejścia-wyjścia - I/O)
        // Każdy wiersz wejściowy próbujemy dopasować do wyrażenia regularnego.
        Files.lines(Path.of(args[0])).forEach( line -> {
            // Pobieramy i wyświetlamy po kolei każdy dopasowany wiersz.
            Matcher m = patt.matcher(line);
            while (m.find()) {
                // Najprostszy sposób:
                // System.out.println(m.group(0));

                // Pobieramy indeks początku tekstu.
                int start = m.start(0);
                // Pobieramy indeks końca tekstu.
                int end = m.end(0);
                // Wyświetlamy dopasowany fragment tekstu,
                // używając metody CharacterIterator.substring(offset, end);
                System.out.println(line.substring(start, end));
            }
        });
    }
}
