package network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

/**
 * Pokazuje niektóre zastosowania klasy NetworkInterface
 */
// tag::main[]
public class NetworkInterfaceDemo {
    public static void main(String[] a) throws IOException {
        Enumeration<NetworkInterface> list = 
                NetworkInterface.getNetworkInterfaces();
        while (list.hasMoreElements()) {
            // Pobieramy jeden interfejs - NetworkInterface.
            NetworkInterface iface = list.nextElement();
            // Wyświetlamy jego nazwę...
            System.out.println(iface.getDisplayName());
            Enumeration<InetAddress> addrs = iface.getInetAddresses();
            // ...oraz jego adresy.
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                System.out.println(addr);
            }
        }

        // Próbujemy pobrać interfejs dla adresu lokalnego (tego komputera).
        InetAddress destAddr = InetAddress.getByName("laptop");
        try {
            NetworkInterface dest = NetworkInterface.getByInetAddress(destAddr);
            System.out.println("Komputer " + destAddr + " ma adres " + dest);
        } catch (SocketException ex) {
            System.err.println("Nie można pobrać adresu komputera " + destAddr);
        }
    }
}
// end::main[]
