package network;

import java.io.*;
import java.net.*;
import java.time.*;

/**
 * DaytimeObject - program nawiązuje połączenie z niestandardową 
 * usługą Time (obiekt LocalDateTime).
 * @author Ian F. Darwin
 */
public class DaytimeObject {
    /** Port TCP używany przez usługę. */
    public static final short TIME_PORT = 1951;

    public static void main(String[] argv) {
        String hostName = argv.length == 0 ? "localhost" : argv[0];

        // tag::main[]
        try (Socket sock = new Socket(hostName, TIME_PORT);) {
            ObjectInputStream is = new ObjectInputStream(new 
                BufferedInputStream(sock.getInputStream()));

            // Odczytujemy i sprawdzamy poprawność danej klasy Object.
            Object o = is.readObject();
            if (o == null) {
                System.err.println("Serwer przesłał wartość null!");
            } else if ((o instanceof LocalDateTime)) {

                // Poprawna, rzutujemy do typu LocalDateTime i wyświetlamy.
                LocalDateTime d = (LocalDateTime) o;
                System.out.println("Czas na komputerze " + hostName + " to " + d);
            } else {
                throw new IllegalArgumentException(
                    String.format("Oczekiwano obiektu LocalDateTime, otrzymano %s, typu %s",
                        o, o.getClass()));
            }
        // end::main[]
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(
                "ERROR: Nie można wczytać obiektu java.time.LocalDateTime!!");
        } catch (IOException e) {
            throw new IllegalArgumentException(
                "ERROR: Nie można odczytać obiektu LocalDateTime z serwera!");
        }
    }
}
