package dir_file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

// tag::main[]
/** 
 * Tworzymy jeden lub kilka plików o podanych nazwach.
 * Ostatnie "e" zostało pominięte w hołdzie dla wywołań systemowych Uniksa.
 */
public class Creat {
    public static void main(String[] argv) throws IOException {

        // Upewniamy się, że w argv[0] została podana nazwa pliku 
        // lub innego elementu systemu plików.
        if (argv.length == 0) {
            throw new IllegalArgumentException("Sposób użycia: Creat nazwaPliku [...]");
        }

        for (String arg : argv) {
            // Stworzenie obiektu Path nie ma wpływu na system plików,
            // natomiast wywołanie metody Files.createFile() ma wpływ.
            final Path p = Path.of(arg);
            final Path created = Files.createFile(p);
            System.out.println(created);
        }
    }
}
// end::main[]
