package otherlang;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * ProcessBuilderDemo pokazuje jak uruchomić zewnętrzny program
 * (w tym przypadku notatnik systemu Windows).
 */
public class ProcessBuilderDemo {

    public static void main(String argv[]) throws Exception {
        // tag::main[]
        List<String> command = new ArrayList<>();            // <1>
        command.add("notepad");
        command.add("foo.txt");
        ProcessBuilder builder = new ProcessBuilder(command);// <2>
        builder.environment().put("PATH", 
                "/windows;/windows/system32;/winnt");        // <3>
        final Process godot = builder.directory(
            new File(System.getProperty("user.home"))).      // <4>
            start();
        System.err.println("Czekając na Godota");            // <5>
        godot.waitFor();                                     // <6>
        // end::main[]

        System.out.println("Program zakończony!");
        return;
    }
}
