
package structure;

import java.util.*;

/**
 * Prosty program demonstrujący działanie interfejsu Iterable.
 */
// tag::main[]
public class IterableDemo {

    /** Klasa Demo implementuje interfejs Iterable, co oznacza, że musi 
     * dostarczać iterator oraz że możemy jej używać w pętlach foreach.
     */
    static class Demo implements Iterable<String> {

        // Prosty przykład: używamy tablicy zamiast wymyślać własną strukturę danych.
        String[] data = { "One", "Two", "Three"};

        /** To jest iterator, dzięki któremu wszystko jest możliwe. */
        class DemoIterator implements Iterator<String> {
            int i = 0;

            /**
             * Informuje czy są jeszcze jakieś elementy.
             * @return true, jeśli wywołanie next() zakończy się pomyślnie, w przeciwnym razie zwraca false.
             */
            public boolean hasNext() {
                return i < data.length;
            }

            /** @return następny element danych. */
            public String next() {
                return data[i++];
            }

            /** Usuwa obiekt zwrócony przez ostatnie wywołanie next().
             * Iterator nie musi implementować tej metody i ten tego nie robi.
             * @throws UnsupportedOperationException bezwarunkowo.
             */
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }

        /** Metoda, przy użyciu której klasa Demo udostępnia swój iterator. */
        public Iterator<String> iterator() {
            return new DemoIterator();
        }
    }
        
    public static void main(String[] args) {
        Demo demo = new Demo();
        for (String s : demo) {
            System.out.println(s);
        }
    }
}
// end::main[]

