package functional;

import java.io.*;
import java.nio.file.*;
import java.util.*;
import java.util.stream.*;

// tag::main[]
/**
 * Implementacja zliczania liczby wystąpień wyrazów, zapisana w dwóch instrukcjach.
 */
public class WordFreq {
    public static void main(String[] args) throws IOException {

        // 1) Zgromadzenie słów w kolekcji Map<String, Long>, ze zliczeniem i usunięciem powtórzeń.
        Map<String,Long> map = Files.lines(Path.of(args[0]))
            .flatMap(s -> Stream.of(s.split(" +")))
            .collect(Collectors.groupingBy(
                String::toLowerCase, Collectors.counting()));

        // 2) Wyświetlenie 20 pierwszych wyników, posortowanych liczbowo w kolejności malejącej.
        map.entrySet().stream()
            .sorted(Map.Entry.<String,Long>comparingByValue().reversed())
            .limit(20)
            .map(entry -> String.format("%4d %s", entry.getValue(), entry.getKey()))
            .forEach(System.out::println);
    }
}
// end::main[]
