package xml.jaxb;

import static org.junit.Assert.*;
import static org.hamcrest.Matchers.*;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.junit.Test;

/**
 * Program testowy pokazujący zapisywanie i wczytywanie danych 
 * przy użyciu JAXB; należy go rzutować na test JUnit, by zapewnić
 * prawidłowe wczytanie danych.  
 */
public class ConfigTest {

    @Test
    public void test() throws Exception {
        System.out.println("JAXB Testing");

        // Tworzymy obiekt Config i sprawdzamy czy nie jest pusty.
        Configuration c = new Configuration();
        assertEquals(c,c);
        
        // Użytkownik określa swoje ustawienia...
        c.setScreenName("idarwin");
        c.setColorName("szaro-zielony");
        c.setVerbose(true);

        // Sprawdzamy czy obiekt nie jest pusty.
        assertEquals(c,c);
        
        Configuration c1 = new Configuration();
        c1.setScreenName(c.getScreenName());
        c1.setColorName(c.getColorName());
        c1.setVerbose(!c.isVerbose());    // Negujemy pole na potrzeby testu.

        // Sprawdzamy czy obiekty są różne od siebie.
        assertThat(c, not(equalTo(c1)));

        // BEGIN main
        // Konfigurujemy JAXB: argumentem kontekstu jest nazwa pakietu!
        JAXBContext jc = JAXBContext.newInstance("xml.jaxb");
        Marshaller saver = jc.createMarshaller();
        final File f = new File("config.save");
        
        // Zapisujemy ustawienia, czyli obiekt
        // Configuration c = ..., który został wcześniej utworzony.
        Writer saveFile = new FileWriter(f);
        saver.marshal(c, saveFile);
        saveFile.close();

        // Upewniamy się, że plik XML został zapisany.
        assertTrue(f.exists());
        System.out.println("Wyniki JAXB zapisane w pliku " + f.getAbsolutePath());
        
        // Jakiś czas później, wczytujemy plik.
        Unmarshaller loader = jc.createUnmarshaller();
        Configuration c2 = (Configuration) loader.unmarshal(f);
        
        // Poza symulacją sprawdzamy, czy to, co wczytaliśmy,
        // jest tym samym, co wcześniej zostało zapisane.
        assertEquals("Zapisany obiekt został wczytany.", c, c2);
        // END main

        // Troche porządków
        f.delete();
    }
}
