/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class ReloadingList
extends Vector<String> {
    private static final long serialVersionUID = -2116296360428588971L;
    private File file;
    private int seconds;
    private static final int DEFAULT_INTERVAL_SECONDS = 120;
    private long mtime;

    public ReloadingList(String fileName) {
        this(fileName, 120);
    }

    public ReloadingList(String fileName, int seconds) {
        this.file = new File(fileName);
        if (!(this.file.exists() && this.file.isFile() && this.file.canRead())) {
            throw new IllegalArgumentException("Not a readable file: " + fileName);
        }
        this.seconds = seconds;
        Thread watcher = new Thread(new Watcher());
        watcher.setDaemon(true);
        watcher.start();
    }

    protected synchronized void read() {
        try {
            String line;
            BufferedReader is = new BufferedReader(new FileReader(this.file));
            this.clear();
            while ((line = is.readLine()) != null) {
                this.add(line);
            }
            is.close();
            this.mtime = this.file.lastModified();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    class Watcher
    implements Runnable {
        Watcher() {
        }

        @Override
        public void run() {
            while (true) {
                if (ReloadingList.this.mtime != ReloadingList.this.file.lastModified()) {
                    ReloadingList.this.read();
                }
                try {
                    Thread.sleep(1000 * ReloadingList.this.seconds);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

