/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import com.darwinsys.util.EnumerationIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class FileProperties
extends Properties {
    private static final long serialVersionUID = 3760847843971053111L;
    protected String fileName = null;
    private boolean exists = false;

    public FileProperties(String loadsaveFileName) throws IOException {
        this.setFileName(loadsaveFileName);
        this.load();
    }

    public FileProperties(String readonlyFileName, Class clazz) throws IOException {
        this.load(clazz.getResourceAsStream(readonlyFileName));
    }

    public FileProperties(InputStream is) throws IOException {
        this.load(is);
    }

    public FileProperties(String loadsaveFileName, Properties defProp) throws IOException {
        super(defProp);
        this.setFileName(loadsaveFileName);
        this.load();
    }

    void setFileName(String newName) {
        File f2;
        this.fileName = newName;
        if (new File(this.fileName).exists()) {
            this.exists = true;
            return;
        }
        if (!newName.endsWith(".properties") && (f2 = new File(newName + ".properties")).exists()) {
            this.exists = true;
            this.fileName = newName + ".properties";
            return;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public Properties load() throws IOException {
        if (!this.exists) {
            return this;
        }
        FileInputStream inStr = new FileInputStream(this.fileName);
        this.load(inStr);
        ((InputStream)inStr).close();
        return this;
    }

    @Deprecated
    public void save() throws IOException {
        if (this.fileName == null) {
            throw new IOException("Tried to save a FileProperties loaded from CLASSPATH");
        }
        FileOutputStream outStr = new FileOutputStream(this.fileName);
        this.store(outStr, "# Written by FileProperties.save() at " + new Date());
        ((OutputStream)outStr).close();
    }

    public Iterator<String> iterator() {
        return new EnumerationIterator<Object>(this.keys());
    }
}

