/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.testing;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestUtils {
    public static boolean equals(Object o1, Object o2) {
        Class<?> c2;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> c1 = o1.getClass();
        if (c1 != (c2 = o2.getClass())) {
            throw new IllegalArgumentException("Cannot compare " + c1 + " with " + c2);
        }
        Map<String, Prop> props = TestUtils.getProperties(c1);
        ArrayList<String> propNames = new ArrayList<String>(props.keySet());
        for (String name : propNames) {
            System.err.println("Trying property " + name);
            Prop prop = props.get(name);
            if (prop == null) {
                throw new IllegalStateException("No Prop descriptor found for " + name);
            }
            if (prop.rawField == null) {
                throw new IllegalStateException("No RawField in Prop descriptor for " + name);
            }
            if (TestUtils.propsEquals(prop.rawField, o1, o2)) continue;
            return false;
        }
        return true;
    }

    public static List<String> compareAll(Object o1, Object o2) {
        Class<?> c2;
        ArrayList<String> different = new ArrayList<String>();
        if (o1 == o2) {
            return different;
        }
        if (o1 == null || o2 == null) {
            return different;
        }
        Class<?> c1 = o1.getClass();
        if (c1 != (c2 = o2.getClass())) {
            throw new IllegalArgumentException("Cannot compare " + c1 + " with " + c2);
        }
        Map<String, Prop> props = TestUtils.getProperties(c1);
        for (String name : props.keySet()) {
            System.err.println("Trying property " + name);
            Prop prop = props.get(name);
            if (prop == null) {
                throw new IllegalStateException("No Prop descriptor found for " + name);
            }
            if (prop.rawField == null) {
                throw new IllegalStateException("No RawField in Prop descriptor for " + name);
            }
            if (TestUtils.propsEquals(prop.rawField, o1, o2)) continue;
            different.add(name);
        }
        return different;
    }

    public static void assertNoDefaultProperties(Object o) throws Exception {
        if (o == null) {
            throw new NullPointerException("Object may not be null");
        }
        Class<?> c = o.getClass();
        Map<String, Prop> props = TestUtils.getProperties(c);
        ArrayList<String> propNames = new ArrayList<String>(props.keySet());
        for (String name : propNames) {
            Prop p = props.get(name);
            Object target = null;
            if (p.rawField != null) {
                target = p.rawField.get(o);
            } else if (p.getter != null) {
                target = p.getter.invoke(o, new Object[0]);
            }
            System.out.printf("Field %s, value %s%n", name, target);
            if (target == null || target.equals(Boolean.FALSE)) {
                throw new AssertionError((Object)("property " + p.name + " is default"));
            }
        }
        System.out.println("assertNoDefaultProperties didn't find any problems");
    }

    private static Map<String, Prop> getProperties(Class c1) {
        Method[] methods;
        Field[] fields;
        HashMap<String, Prop> propsMap = new HashMap<String, Prop>();
        for (Field f : fields = c1.getDeclaredFields()) {
            f.setAccessible(true);
            String fieldName = f.getName();
            Prop p = (Prop)propsMap.get(fieldName);
            if (p == null) {
                p = new Prop(fieldName);
                propsMap.put(fieldName, p);
            }
            p.rawField = f;
        }
        for (Method m : methods = c1.getDeclaredMethods()) {
            m.setAccessible(true);
            String methodName = m.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("set")) continue;
            String propName = methodName.substring(3);
            Prop p = (Prop)propsMap.get(propName = propName.substring(0, 1).toLowerCase() + propName.substring(1));
            if (p == null) {
                p = new Prop(propName);
                propsMap.put(propName, p);
            }
            if (methodName.startsWith("get")) {
                p.getter = m;
                continue;
            }
            if (methodName.startsWith("set")) {
                p.setter = m;
                continue;
            }
            throw new IllegalStateException("invalid name " + methodName);
        }
        return propsMap;
    }

    private static boolean propsEquals(Member member, Object o1, Object o2) {
        if (member == null) {
            throw new IllegalStateException("Member is null in propsEquals");
        }
        try {
            if (member instanceof Field) {
                Field f = (Field)member;
                System.out.println(String.format("EqualsUtils.propsEquals(%s)", f.getName()));
                Object val1 = f.get(o1);
                Object val2 = f.get(o2);
                return val1.equals(val2);
            }
            if (member instanceof Method) {
                Method m = (Method)member;
                String methodName = m.getName();
                if (methodName.startsWith("set")) {
                    return true;
                }
                Object v1 = m.invoke(o1, new Object[0]);
                Object v2 = m.invoke(o2, new Object[0]);
                if (v1 == null && v2 == null) {
                    return true;
                }
                if (v1 == null || v2 == null) {
                    return false;
                }
                return v1.equals(v2);
            }
            throw new IllegalArgumentException("Internal error: member " + member + " neither Method nor Field");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static class Prop {
        String name;
        Field rawField;
        Method getter;
        Method setter;

        Prop(String name) {
            this.name = name;
        }

        public String toString() {
            return "Prop(" + this.name + ")";
        }
    }
}

