/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UtilGUI {
    public static void centre(Window w) {
        Dimension us = w.getSize();
        Dimension them = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = (them.width - us.width) / 2;
        int newY = (them.height - us.height) / 2;
        w.setLocation(newX, newY);
    }

    public static void center(Window w) {
        UtilGUI.centre(w);
    }

    public static void maximize(Window w) {
        Dimension them = Toolkit.getDefaultToolkit().getScreenSize();
        w.setBounds(0, 0, them.width, them.height);
    }

    public static void setSystemClipboardContents(Component c, String srcData) {
        if (srcData != null) {
            Clipboard clipboard = c.getToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection(srcData);
            clipboard.setContents(contents, new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
    }

    public static boolean confirm(JFrame parent, String message) {
        int confirm = JOptionPane.showConfirmDialog(parent, message, "Confirm", 0, 3);
        return confirm == 0;
    }

    public static void setSavedLocation(Preferences pNode, Window w) {
        Point where = w.getLocation();
        int x = (int)where.getX();
        pNode.putInt("mainwindow.x", Math.max(0, x));
        int y = (int)where.getY();
        pNode.putInt("mainwindow.y", Math.max(0, y));
    }

    public static Point getSavedLocation(Preferences pNode) {
        int savedX = pNode.getInt("mainwindow.x", -1);
        int savedY = pNode.getInt("mainwindow.y", -1);
        return new Point(savedX, savedY);
    }

    public static void monitorWindowPosition(final Window w, final Preferences pNode) {
        Point p = UtilGUI.getSavedLocation(pNode);
        int savedX = (int)p.getX();
        int savedY = (int)p.getY();
        if (savedX != -1) {
            w.setLocation(savedX, savedY);
        } else {
            UtilGUI.centre(w);
        }
        w.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                UtilGUI.setSavedLocation(pNode, w);
            }
        });
    }
}

