/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.security;

import com.darwinsys.security.Strength;

public class PasswordStrength {
    public static final String[] commonPasswords = new String[]{"password", "pass", "1234", "1246", "2468"};
    public static final String DIGITS = "0123456789";
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String PUNCTUATION = "!.@$#*()%~<>{}[]";

    public Strength checkPassword(String password) {
        int combinations = 0;
        if (this.containsAny(password, DIGITS)) {
            combinations += 10;
        }
        if (this.containsAny(password, LOWERCASE)) {
            combinations += 26;
        }
        if (this.containsAny(password, UPPERCASE)) {
            combinations += 26;
        }
        if (this.containsAny(password, PUNCTUATION)) {
            combinations += PUNCTUATION.length();
        }
        int totalCombinations = (int)Math.pow(combinations, password.length());
        if (this.isCommonPassword(password)) {
            return Strength.USELESS;
        }
        int timeInSeconds = totalCombinations / 200 / 2;
        int timeInDays = timeInSeconds / 86400;
        double lifetime = 365.23;
        double ratio = (double)timeInDays / lifetime;
        if (ratio > 1.0) {
            return Strength.STRONG;
        }
        if (ratio > 0.1) {
            return Strength.WEAK;
        }
        if (ratio <= 0.1) {
            return Strength.USELESS;
        }
        return Strength.MEDIUM;
    }

    private boolean isCommonPassword(String password) {
        for (int i = 0; i < commonPasswords.length; ++i) {
            if (!password.equalsIgnoreCase(commonPasswords[i])) continue;
            return true;
        }
        return false;
    }

    private final boolean containsAny(String password, String validChars) {
        for (int i = 0; i < password.length(); ++i) {
            char ch = password.charAt(i);
            if (validChars.indexOf(ch) <= -1) continue;
            return true;
        }
        return false;
    }
}

