/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.locks;

import com.darwinsys.locks.Lock;
import com.darwinsys.locks.LockImpl;
import com.darwinsys.locks.LockReaperImpl;
import com.darwinsys.locks.PessimisticLockException;
import com.darwinsys.locks.PessimisticLockManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PessimisticLockManagerImpl<T>
implements PessimisticLockManager<T> {
    public static final int DEFAULT_TIMEOUT = 15;
    private int timeout = 15;
    private Map<Lock, T> locks = new HashMap<Lock, T>();
    private LockReaperImpl<T> lockReaper;

    public Map<Lock, T> getLockStore() {
        return new HashMap<Lock, T>(this.locks);
    }

    public List<Lock> getLocks() {
        return new ArrayList<Lock>(this.locks.keySet());
    }

    public PessimisticLockManagerImpl() {
        this.setTimeout(15);
    }

    @Override
    public void start() {
        this.lockReaper = new LockReaperImpl(this, this.timeout);
        if (!this.lockReaper.isAlive()) {
            this.lockReaper.start();
        }
    }

    @Override
    public Lock tryLock(T id) {
        return this.tryLock(id, null);
    }

    @Override
    public synchronized Lock tryLock(T id, Object owner) {
        if (this.lockReaper == null) {
            this.start();
        }
        if (!this.locks.containsValue(id)) {
            LockImpl<T> l = new LockImpl<T>(this, id, owner);
            this.locks.put(l, id);
            return l;
        }
        throw new PessimisticLockException("Lock in use for " + id);
    }

    @Override
    public synchronized boolean releaseLock(Lock lock) {
        if (this.locks.containsKey(lock)) {
            ((LockImpl)lock).setReleased(true);
            boolean removed = this.locks.remove(lock) != null;
            return removed;
        }
        return false;
    }

    public synchronized void close() {
        this.lockReaper.setDone(true);
        for (Lock l : this.getLocks()) {
            l.release();
            this.locks.remove(l);
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return String.format("PessimisticLockManagerImpl with %d locks", this.locks.keySet().size());
    }
}

