/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import java.io.IOException;
import java.io.Reader;

public class ReloadableStringReader
extends Reader {
    protected String contents;
    protected static final int MARK_INVALID = -1;
    protected int mark = -1;
    protected int pos;

    public ReloadableStringReader(String input) {
        this.setString(input);
    }

    public ReloadableStringReader() {
    }

    public void setString(String s) {
        this.contents = s;
        this.pos = 0;
        this.mark = -1;
    }

    @Override
    public int read() {
        if (this.contents == null) {
            throw new IllegalStateException("No string provided");
        }
        return this.pos < this.contents.length() ? (int)this.contents.charAt(this.pos++) : -1;
    }

    @Override
    public int read(char[] data) {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(char[] data, int off, int len) {
        int n = 0;
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                return n > 0 ? n : -1;
            }
            data[i + off] = (char)ch;
            ++n;
        }
        return n;
    }

    public int available() {
        return this.contents.length() - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        if (this.mark == -1) {
            throw new IllegalArgumentException("mark not set");
        }
        this.pos = this.mark;
    }

    @Override
    public long skip(long n) {
        long actual = Math.min(n, (long)this.available());
        this.pos = (int)actual;
        return actual;
    }

    @Override
    public void close() throws IOException {
    }
}

