/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.diff;

import java.util.ArrayList;
import java.util.Hashtable;

public class Diff {
    public static Item[] diffText(String TextA, String TextB) {
        return Diff.diffText(TextA, TextB, false, false, false);
    }

    public static Item[] diffText(String TextA, String TextB, boolean trimSpace, boolean ignoreSpace, boolean ignoreCase) {
        Hashtable<String, Integer> h = new Hashtable<String, Integer>(TextA.length() + TextB.length());
        DiffData DataA = new DiffData(Diff.DiffCodes(TextA, h, trimSpace, ignoreSpace, ignoreCase));
        DiffData DataB = new DiffData(Diff.DiffCodes(TextB, h, trimSpace, ignoreSpace, ignoreCase));
        h = null;
        int MAX = DataA.Length + DataB.Length + 1;
        int[] DownVector = new int[2 * MAX + 2];
        int[] UpVector = new int[2 * MAX + 2];
        Diff.LCS(DataA, 0, DataA.Length, DataB, 0, DataB.Length, DownVector, UpVector);
        Diff.Optimize(DataA);
        Diff.Optimize(DataB);
        return Diff.CreateDiffs(DataA, DataB);
    }

    private static void Optimize(DiffData Data) {
        int StartPos = 0;
        while (StartPos < Data.Length) {
            int EndPos;
            while (StartPos < Data.Length && !Data.modified[StartPos]) {
                ++StartPos;
            }
            for (EndPos = StartPos; EndPos < Data.Length && Data.modified[EndPos]; ++EndPos) {
            }
            if (EndPos < Data.Length && Data.data[StartPos] == Data.data[EndPos]) {
                ((DiffData)Data).modified[StartPos] = false;
                ((DiffData)Data).modified[EndPos] = true;
                continue;
            }
            StartPos = EndPos;
        }
    }

    public Item[] DiffInt(int[] ArrayA, int[] ArrayB) {
        DiffData DataA = new DiffData(ArrayA);
        DiffData DataB = new DiffData(ArrayB);
        int MAX = DataA.Length + DataB.Length + 1;
        int[] DownVector = new int[2 * MAX + 2];
        int[] UpVector = new int[2 * MAX + 2];
        Diff.LCS(DataA, 0, DataA.Length, DataB, 0, DataB.Length, DownVector, UpVector);
        return Diff.CreateDiffs(DataA, DataB);
    }

    private static int[] DiffCodes(String aText, Hashtable<String, Integer> h, boolean trimSpace, boolean ignoreSpace, boolean ignoreCase) {
        int lastUsedCode = h.size();
        aText = aText.replace("\r", "");
        String[] Lines = aText.split("\n");
        int[] Codes = new int[Lines.length];
        for (int i = 0; i < Lines.length; ++i) {
            Integer aCode;
            String s = Lines[i];
            if (trimSpace) {
                s = s.trim();
            }
            if (ignoreSpace) {
                s = s.replaceAll("\\s+", " ");
            }
            if (ignoreCase) {
                s = s.toLowerCase();
            }
            if ((aCode = h.get(s)) == null) {
                h.put(s, ++lastUsedCode);
                Codes[i] = lastUsedCode;
                continue;
            }
            Codes[i] = aCode;
        }
        return Codes;
    }

    private static SMSRD SMS(DiffData DataA, int LowerA, int UpperA, DiffData DataB, int LowerB, int UpperB, int[] DownVector, int[] UpVector) {
        SMSRD ret = new SMSRD();
        int MAX = DataA.Length + DataB.Length + 1;
        int DownK = LowerA - LowerB;
        int UpK = UpperA - UpperB;
        int Delta = UpperA - LowerA - (UpperB - LowerB);
        boolean oddDelta = (Delta & 1) != 0;
        int DownOffset = MAX - DownK;
        int UpOffset = MAX - UpK;
        int MaxD = (UpperA - LowerA + UpperB - LowerB) / 2 + 1;
        DownVector[DownOffset + DownK + 1] = LowerA;
        UpVector[UpOffset + UpK - 1] = UpperA;
        for (int D = 0; D <= MaxD; ++D) {
            int y;
            int x;
            int k;
            for (k = DownK - D; k <= DownK + D; k += 2) {
                if (k == DownK - D) {
                    x = DownVector[DownOffset + k + 1];
                } else {
                    x = DownVector[DownOffset + k - 1] + 1;
                    if (k < DownK + D && DownVector[DownOffset + k + 1] >= x) {
                        x = DownVector[DownOffset + k + 1];
                    }
                }
                for (y = x - k; x < UpperA && y < UpperB && DataA.data[x] == DataB.data[y]; ++x, ++y) {
                }
                DownVector[DownOffset + k] = x;
                if (!oddDelta || UpK - D >= k || k >= UpK + D || UpVector[UpOffset + k] > DownVector[DownOffset + k]) continue;
                ret.x = DownVector[DownOffset + k];
                ret.y = DownVector[DownOffset + k] - k;
                return ret;
            }
            for (k = UpK - D; k <= UpK + D; k += 2) {
                if (k == UpK + D) {
                    x = UpVector[UpOffset + k - 1];
                } else {
                    x = UpVector[UpOffset + k + 1] - 1;
                    if (k > UpK - D && UpVector[UpOffset + k - 1] < x) {
                        x = UpVector[UpOffset + k - 1];
                    }
                }
                for (y = x - k; x > LowerA && y > LowerB && DataA.data[x - 1] == DataB.data[y - 1]; --x, --y) {
                }
                UpVector[UpOffset + k] = x;
                if (oddDelta || DownK - D > k || k > DownK + D || UpVector[UpOffset + k] > DownVector[DownOffset + k]) continue;
                ret.x = DownVector[DownOffset + k];
                ret.y = DownVector[DownOffset + k] - k;
                return ret;
            }
        }
        throw new IllegalStateException("the algorithm should never come here.");
    }

    private static void LCS(DiffData DataA, int LowerA, int UpperA, DiffData DataB, int LowerB, int UpperB, int[] DownVector, int[] UpVector) {
        while (LowerA < UpperA && LowerB < UpperB && DataA.data[LowerA] == DataB.data[LowerB]) {
            ++LowerA;
            ++LowerB;
        }
        while (LowerA < UpperA && LowerB < UpperB && DataA.data[UpperA - 1] == DataB.data[UpperB - 1]) {
            --UpperA;
            --UpperB;
        }
        if (LowerA == UpperA) {
            while (LowerB < UpperB) {
                ((DiffData)DataB).modified[LowerB++] = true;
            }
        } else if (LowerB == UpperB) {
            while (LowerA < UpperA) {
                ((DiffData)DataA).modified[LowerA++] = true;
            }
        } else {
            SMSRD smsrd = Diff.SMS(DataA, LowerA, UpperA, DataB, LowerB, UpperB, DownVector, UpVector);
            Diff.LCS(DataA, LowerA, smsrd.x, DataB, LowerB, smsrd.y, DownVector, UpVector);
            Diff.LCS(DataA, smsrd.x, UpperA, DataB, smsrd.y, UpperB, DownVector, UpVector);
        }
    }

    private static Item[] CreateDiffs(DiffData DataA, DiffData DataB) {
        ArrayList<Item> a = new ArrayList<Item>();
        int LineA = 0;
        int LineB = 0;
        while (LineA < DataA.Length || LineB < DataB.Length) {
            if (LineA < DataA.Length && !DataA.modified[LineA] && LineB < DataB.Length && !DataB.modified[LineB]) {
                ++LineA;
                ++LineB;
                continue;
            }
            int StartA = LineA;
            int StartB = LineB;
            while (LineA < DataA.Length && (LineB >= DataB.Length || DataA.modified[LineA])) {
                ++LineA;
            }
            while (LineB < DataB.Length && (LineA >= DataA.Length || DataB.modified[LineB])) {
                ++LineB;
            }
            if (StartA >= LineA && StartB >= LineB) continue;
            Item aItem = new Item();
            aItem.StartA = StartA;
            aItem.StartB = StartB;
            aItem.deletedA = LineA - StartA;
            aItem.insertedB = LineB - StartB;
            a.add(aItem);
        }
        Item[] result = a.toArray(new Item[a.size()]);
        return result;
    }

    static class DiffData {
        private int Length;
        private int[] data;
        private boolean[] modified;

        protected DiffData(int[] initData) {
            this.data = initData;
            this.Length = initData.length;
            this.modified = new boolean[this.Length + 2];
        }
    }

    private static class SMSRD {
        int x;
        int y;

        private SMSRD() {
        }
    }

    public static class Item {
        public int StartA;
        public int StartB;
        public int deletedA;
        public int insertedB;
    }
}

