/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tabbedpane;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.util.AddResource;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTab;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane;
import org.apache.myfaces.custom.tabbedpane.TabChangeEvent;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;

public class HtmlTabbedPaneRenderer
extends HtmlRenderer {
    private static final String ACTIVE_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_activeHeaderCell";
    private static final String INACTIVE_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_inactiveHeaderCell";
    private static final String DISABLED_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_disabledHeaderCell";
    private static final String EMPTY_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_emptyHeaderCell";
    private static final String SUB_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_subHeaderCell";
    private static final String SUB_HEADER_CELL_CLASS_ACTIVE = "myFaces_panelTabbedPane_subHeaderCell_active";
    private static final String SUB_HEADER_CELL_CLASS_INACTIVE = "myFaces_panelTabbedPane_subHeaderCell_inactive";
    private static final String SUB_HEADER_CELL_CLASS_FIRST = "myFaces_panelTabbedPane_subHeaderCell_first";
    private static final String SUB_HEADER_CELL_CLASS_LAST = "myFaces_panelTabbedPane_subHeaderCell_last";
    private static final String TAB_PANE_CLASS = "myFaces_panelTabbedPane_pane";
    private static final String DEFAULT_BG_COLOR = "white";
    private static final String AUTO_FORM_SUFFIX = ".autoform";
    static /* synthetic */ Class class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane;
    static /* synthetic */ Class class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer;

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
    }

    private boolean isDynamic() {
        return true;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane")) : class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane);
        HtmlPanelTabbedPane tabbedPane = (HtmlPanelTabbedPane)uiComponent;
        if (tabbedPane.getBgcolor() == null) {
            tabbedPane.setBgcolor(DEFAULT_BG_COLOR);
        }
        AddResource.addStyleSheet(class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlTabbedPaneRenderer")) : class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer, "defaultStyles.css", facesContext);
        if (this.isDynamic()) {
            AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlTabbedPaneRenderer")) : class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer, "dynamicTabs.js", facesContext);
            AddResource.addInlineStyleToHeader('#' + this.getTableStylableId(tabbedPane, facesContext) + " ." + ACTIVE_HEADER_CELL_CLASS + " input,\n" + '#' + this.getTableStylableId(tabbedPane, facesContext) + " ." + TAB_PANE_CLASS + ",\n" + '#' + this.getTableStylableId(tabbedPane, facesContext) + " ." + SUB_HEADER_CELL_CLASS + "{\n" + "background-color:" + tabbedPane.getBgcolor() + ";\n" + "}\n", facesContext);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        int selectedIndex = tabbedPane.getSelectedIndex();
        UIForm parentForm = RendererUtils.findParentForm(tabbedPane);
        if (parentForm == null) {
            this.writeFormStart(writer, facesContext, tabbedPane);
        }
        List children = tabbedPane.getChildren();
        if (this.isDynamic()) {
            ArrayList<String> headerIDs = new ArrayList<String>();
            ArrayList<String> tabIDs = new ArrayList<String>();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                UIComponent child = this.getUIComponent((UIComponent)children.get(i));
                if (!(child instanceof HtmlPanelTab) || !child.isRendered()) continue;
                HtmlPanelTab tab = (HtmlPanelTab)child;
                tabIDs.add(child.getClientId(facesContext));
                if (this.isDisabled(facesContext, tab)) continue;
                headerIDs.add(this.getHeaderCellID(tab, facesContext));
            }
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("script", tabbedPane);
            writer.write(10);
            writer.write(this.getHeaderCellsIDsVar(tabbedPane, facesContext) + "= new Array(");
            Iterator ids = headerIDs.iterator();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                writer.write('\"' + JavascriptUtils.encodeString(id) + '\"');
                if (!ids.hasNext()) continue;
                writer.write(44);
            }
            writer.write(");\n");
            writer.write(this.getTabsIDsVar(tabbedPane, facesContext) + "= new Array(");
            ids = tabIDs.iterator();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                writer.write('\"' + JavascriptUtils.encodeString(id) + '\"');
                if (!ids.hasNext()) continue;
                writer.write(44);
            }
            writer.write(");\n");
            writer.endElement("script");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            String submitFieldIDAndName = this.getTabIndexSubmitFieldIDAndName(tabbedPane, facesContext);
            writer.startElement("input", tabbedPane);
            writer.writeAttribute("id", submitFieldIDAndName, null);
            writer.writeAttribute("name", submitFieldIDAndName, null);
            writer.writeAttribute("style", "display:none", null);
            writer.endElement("input");
        }
        this.writeTableStart(writer, facesContext, tabbedPane);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", tabbedPane);
        int tabIdx = 0;
        int visibleTabCount = 0;
        int visibleTabSelectedIdx = -1;
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (!(child instanceof HtmlPanelTab)) continue;
            if (child.isRendered()) {
                this.writeHeaderCell(writer, facesContext, tabbedPane, (HtmlPanelTab)child, tabIdx, visibleTabCount, tabIdx == selectedIndex, this.isDisabled(facesContext, child));
                if (tabIdx == selectedIndex) {
                    visibleTabSelectedIdx = visibleTabCount;
                }
                ++visibleTabCount;
            }
            ++tabIdx;
        }
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", tabbedPane);
        writer.writeAttribute("class", EMPTY_HEADER_CELL_CLASS, null);
        writer.write("&#160;");
        writer.endElement("td");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", tabbedPane);
        this.writeSubHeaderCells(writer, facesContext, tabbedPane, visibleTabCount, visibleTabSelectedIdx);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", tabbedPane);
        writer.startElement("td", tabbedPane);
        writer.writeAttribute("colspan", Integer.toString(visibleTabCount + 1), null);
        String tabContentStyleClass = tabbedPane.getTabContentStyleClass();
        writer.writeAttribute("class", TAB_PANE_CLASS + (tabContentStyleClass == null ? "" : " " + tabContentStyleClass), null);
        this.writeTabsContents(writer, facesContext, tabbedPane, selectedIndex);
        writer.endElement("td");
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("table");
        if (parentForm == null) {
            this.writeFormEnd(writer, facesContext);
        }
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String clientSideIndex;
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane")) : class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane);
        HtmlPanelTabbedPane tabbedPane = (HtmlPanelTabbedPane)uiComponent;
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        int tabIdx = 0;
        List children = tabbedPane.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (!(child instanceof HtmlPanelTab)) continue;
            String paramName = tabbedPane.getClientId(facesContext) + "." + tabIdx;
            String paramValue = (String)paramMap.get(paramName);
            if (paramValue != null && paramValue.length() > 0) {
                tabbedPane.queueEvent(new TabChangeEvent(tabbedPane, tabbedPane.getSelectedIndex(), tabIdx));
                return;
            }
            ++tabIdx;
        }
        if (this.isDynamic() && (clientSideIndex = (String)paramMap.get(this.getTabIndexSubmitFieldIDAndName(tabbedPane, facesContext))) != null && clientSideIndex.length() > 0) {
            tabbedPane.setSelectedIndex(Integer.parseInt(clientSideIndex));
            return;
        }
    }

    protected void writeFormStart(ResponseWriter writer, FacesContext facesContext, UIComponent tabbedPane) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String actionURL = viewHandler.getActionURL(facesContext, viewId);
        writer.startElement("form", tabbedPane);
        writer.writeAttribute("name", tabbedPane.getClientId(facesContext) + AUTO_FORM_SUFFIX, null);
        writer.writeAttribute("style", "display:inline", null);
        writer.writeAttribute("method", "post", null);
        writer.writeURIAttribute("action", facesContext.getExternalContext().encodeActionURL(actionURL), null);
        writer.flush();
    }

    protected String getHeaderCellsIDsVar(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        return JavascriptUtils.getValidJavascriptName("panelTabbedPane_" + tabbedPane.getClientId(facesContext) + "_HeadersIDs", false);
    }

    protected String getTabsIDsVar(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        return JavascriptUtils.getValidJavascriptName("panelTabbedPane_" + tabbedPane.getClientId(facesContext) + "_IDs", false);
    }

    protected String getDefaultActiveHeaderStyleClass(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        return JavascriptUtils.getValidJavascriptName("panelTabbedPane_" + tabbedPane.getClientId(facesContext) + "_ActiveStyle", false);
    }

    protected String getActiveHeaderClasses(HtmlPanelTabbedPane tabbedPane) {
        String userActiveStyleClass = tabbedPane.getActiveTabStyleClass();
        if (userActiveStyleClass == null || userActiveStyleClass.length() == 0) {
            return ACTIVE_HEADER_CELL_CLASS;
        }
        return "myFaces_panelTabbedPane_activeHeaderCell " + userActiveStyleClass;
    }

    protected String getInactiveHeaderClasses(HtmlPanelTabbedPane tabbedPane) {
        String userInactiveStyleClass = tabbedPane.getInactiveTabStyleClass();
        if (userInactiveStyleClass == null || userInactiveStyleClass.length() == 0) {
            return INACTIVE_HEADER_CELL_CLASS;
        }
        return "myFaces_panelTabbedPane_inactiveHeaderCell " + userInactiveStyleClass;
    }

    protected void writeTableStart(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane) throws IOException {
        String oldBgColor = tabbedPane.getBgcolor();
        tabbedPane.setBgcolor(null);
        writer.startElement("table", tabbedPane);
        writer.writeAttribute("id", this.getTableStylableId(tabbedPane, facesContext), null);
        writer.writeAttribute("class", "myFaces_panelTabbedPane", null);
        writer.writeAttribute("cellspacing", "0", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, tabbedPane, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.flush();
        tabbedPane.setBgcolor(oldBgColor);
    }

    protected String getTableStylableId(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        String originalID = tabbedPane.getClientId(facesContext);
        return originalID.replace(':', '_');
    }

    protected String getTabIndexSubmitFieldIDAndName(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        return tabbedPane.getClientId(facesContext) + "_indexSubmit";
    }

    protected String getHeaderCellID(HtmlPanelTab tab, FacesContext facesContext) {
        return tab.getClientId(facesContext) + "_headerCell";
    }

    private String getSubHeaderCellID(HtmlPanelTab tab, FacesContext facesContext) {
        return tab.getClientId(facesContext) + "_headerCell_sub";
    }

    protected void writeHeaderCell(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, HtmlPanelTab tab, int tabIndex, int visibleTabIndex, boolean active, boolean disabled) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", tabbedPane);
        writer.writeAttribute("id", this.getHeaderCellID(tab, facesContext), null);
        if (disabled) {
            String disabledClass = tabbedPane.getDisabledTabStyleClass();
            writer.writeAttribute("class", DISABLED_HEADER_CELL_CLASS + (disabledClass == null ? "" : ' ' + disabledClass), null);
        } else if (active) {
            writer.writeAttribute("class", this.getActiveHeaderClasses(tabbedPane), null);
        } else {
            writer.writeAttribute("class", this.getInactiveHeaderClasses(tabbedPane), null);
        }
        String label = tab.getLabel();
        if (label == null || label.length() == 0) {
            label = "Tab " + tabIndex;
        }
        if (disabled) {
            writer.startElement("label", tabbedPane);
            writer.writeText(label, null);
            writer.endElement("label");
        } else {
            writer.startElement("input", tabbedPane);
            writer.writeAttribute("type", "submit", null);
            writer.writeAttribute("name", tabbedPane.getClientId(facesContext) + "." + tabIndex, null);
            writer.writeAttribute("value", label, null);
            if (this.isDynamic()) {
                String activeUserClass = tabbedPane.getActiveTabStyleClass();
                String inactiveUserClass = tabbedPane.getInactiveTabStyleClass();
                String activeSubStyleUserClass = tabbedPane.getActiveSubStyleClass();
                String inactiveSubStyleUserClass = tabbedPane.getInactiveSubStyleClass();
                writer.writeAttribute("onclick", "return myFaces_showPanelTab(" + tabIndex + ",'" + this.getTabIndexSubmitFieldIDAndName(tabbedPane, facesContext) + "'," + '\'' + this.getHeaderCellID(tab, facesContext) + "','" + tab.getClientId(facesContext) + "'," + this.getHeaderCellsIDsVar(tabbedPane, facesContext) + ',' + this.getTabsIDsVar(tabbedPane, facesContext) + ',' + (activeUserClass == null ? "null" : '\'' + activeUserClass + '\'') + ',' + (inactiveUserClass == null ? "null" : '\'' + inactiveUserClass + '\'') + ',' + (activeSubStyleUserClass == null ? "null" : '\'' + activeSubStyleUserClass + '\'') + ',' + (inactiveSubStyleUserClass == null ? "null" : '\'' + inactiveSubStyleUserClass + '\'') + ");", null);
            }
            writer.endElement("input");
        }
        writer.endElement("td");
    }

    protected void writeSubHeaderCells(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, int visibleTabCount, int visibleTabSelectedIndex) throws IOException {
        String activeSubStyleUserClass = tabbedPane.getActiveSubStyleClass();
        String inactiveSubStyleUserClass = tabbedPane.getInactiveSubStyleClass();
        List children = tabbedPane.getChildren();
        StringBuffer classes = new StringBuffer();
        int len = children.size();
        int renderedIndex = 0;
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (!(child instanceof HtmlPanelTab) || !child.isRendered()) continue;
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            HtmlRendererUtils.writePrettyIndent(facesContext);
            writer.startElement("td", tabbedPane);
            writer.writeAttribute("id", this.getSubHeaderCellID((HtmlPanelTab)child, facesContext), null);
            classes.setLength(0);
            classes.append(SUB_HEADER_CELL_CLASS);
            if (renderedIndex == 0) {
                classes.append(' ');
                classes.append(SUB_HEADER_CELL_CLASS_FIRST);
            }
            if (renderedIndex == visibleTabCount) {
                classes.append(' ');
                classes.append(SUB_HEADER_CELL_CLASS_LAST);
                if (activeSubStyleUserClass != null) {
                    classes.append(' ');
                    classes.append(activeSubStyleUserClass);
                }
            } else if (inactiveSubStyleUserClass != null) {
                classes.append(' ');
                classes.append(inactiveSubStyleUserClass);
            }
            classes.append(' ');
            classes.append(renderedIndex == visibleTabSelectedIndex ? SUB_HEADER_CELL_CLASS_ACTIVE : SUB_HEADER_CELL_CLASS_INACTIVE);
            writer.writeAttribute("class", classes.toString(), null);
            writer.write("&#160;");
            writer.endElement("td");
            ++renderedIndex;
        }
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", tabbedPane);
        writer.writeAttribute("class", "myFaces_panelTabbedPane_subHeaderCell myFaces_panelTabbedPane_subHeaderCell_last" + (inactiveSubStyleUserClass != null ? ' ' + inactiveSubStyleUserClass : ""), null);
        writer.write("&#160;");
        writer.endElement("td");
    }

    protected void writeTabsContents(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, int selectedIndex) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        int tabIdx = 0;
        List children = tabbedPane.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (child instanceof HtmlPanelTab) {
                HtmlPanelTab tab = (HtmlPanelTab)child;
                writer.startElement("div", tabbedPane);
                writer.writeAttribute("id", tab.getClientId(facesContext), null);
                if (tabIdx != selectedIndex) {
                    writer.writeAttribute("style", "display:none", null);
                }
                RendererUtils.renderChild(facesContext, child);
                writer.endElement("div");
                ++tabIdx;
                continue;
            }
            RendererUtils.renderChild(facesContext, child);
        }
    }

    private UIComponent getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UIForm || uiComponent instanceof UINamingContainer) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }

    protected void writeFormEnd(ResponseWriter writer, FacesContext facesContext) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        viewHandler.writeState(facesContext);
        writer.endElement("form");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        return !UserRoleUtils.isEnabledOnUserRole(uiComponent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

