/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.helpers.ForwardingBootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.environment.se.ShutdownManager;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.discovery.url.WeldSEResourceLoader;
import org.jboss.weld.environment.se.discovery.url.WeldSEUrlDeployment;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.jboss.weld.metadata.MetadataImpl;
import org.jboss.weld.resources.spi.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Weld {
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    private ShutdownManager shutdownManager;
    private Set<Metadata<Extension>> extensions;

    public void addExtension(Extension extension) {
        if (this.extensions == null) {
            this.extensions = new HashSet<Metadata<Extension>>();
        }
        this.extensions.add((Metadata<Extension>)new MetadataImpl((Object)extension, "<explicity-added>"));
    }

    public WeldContainer initialize() {
        Bootstrap delegate;
        WeldSEResourceLoader resourceLoader = new WeldSEResourceLoader();
        if (resourceLoader.getResource("META-INF/beans.xml") == null) {
            throw new IllegalStateException("Missing beans.xml file in META-INF!");
        }
        try {
            delegate = (Bootstrap)resourceLoader.classForName(BOOTSTRAP_IMPL_CLASS_NAME).newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", ex);
        }
        ForwardingBootstrap bootstrap = new ForwardingBootstrap(){

            protected Bootstrap delegate() {
                return delegate;
            }

            public BeansXml parse(URL url) {
                return delegate.parse(url);
            }

            public BeansXml parse(Iterable<URL> urls) {
                return delegate.parse(urls);
            }

            public Iterable<Metadata<Extension>> loadExtensions(ClassLoader classLoader) {
                Iterable iter = delegate.loadExtensions(classLoader);
                if (Weld.this.extensions != null) {
                    HashSet<Metadata<Extension>> set = new HashSet<Metadata<Extension>>(Weld.this.extensions);
                    for (Metadata ext : iter) {
                        set.add((Metadata<Extension>)ext);
                    }
                    return set;
                }
                return iter;
            }
        };
        Deployment deployment = this.createDeployment(resourceLoader, (Bootstrap)bootstrap);
        bootstrap.startContainer((Environment)Environments.SE, deployment);
        bootstrap.startInitialization();
        bootstrap.deployBeans();
        bootstrap.validateBeans();
        bootstrap.endInitialization();
        this.shutdownManager = this.getInstanceByType((BeanManager)bootstrap.getManager(deployment.loadBeanDeploymentArchive(ShutdownManager.class)), ShutdownManager.class, new Annotation[0]);
        this.shutdownManager.setBootstrap((Bootstrap)bootstrap);
        WeldContainer container = this.getInstanceByType((BeanManager)bootstrap.getManager(deployment.loadBeanDeploymentArchive(WeldContainer.class)), WeldContainer.class, new Annotation[0]);
        container.event().select(ContainerInitialized.class, new Annotation[0]).fire((Object)new ContainerInitialized());
        return container;
    }

    protected Deployment createDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap) {
        return new WeldSEUrlDeployment(resourceLoader, bootstrap);
    }

    protected <T> T getInstanceByType(BeanManager manager, Class<T> type, Annotation ... bindings) {
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        if (bean == null) {
            throw new UnsatisfiedResolutionException("Unable to resolve a bean for " + type + " with bindings " + Arrays.asList(bindings));
        }
        CreationalContext cc = manager.createCreationalContext((Contextual)bean);
        return type.cast(manager.getReference(bean, type, cc));
    }

    public void shutdown() {
        this.shutdownManager.shutdown();
    }
}

