/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.perl.inline.java.InlineJavaArray;
import org.perl.inline.java.InlineJavaCastException;
import org.perl.inline.java.InlineJavaClass;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaInvocationTargetException;
import org.perl.inline.java.InlineJavaServer;
import org.perl.inline.java.InlineJavaThrown;
import org.perl.inline.java.InlineJavaUtils;

class InlineJavaProtocol {
    private InlineJavaServer ijs;
    private InlineJavaClass ijc;
    private InlineJavaArray ija;
    private String cmd;
    private String response = null;
    private static HashMap member_cache = new HashMap();

    InlineJavaProtocol(InlineJavaServer inlineJavaServer, String string) {
        this.ijs = inlineJavaServer;
        this.ijc = new InlineJavaClass(this.ijs, this);
        this.ija = new InlineJavaArray(this.ijc);
        this.cmd = string;
    }

    void Do() throws InlineJavaException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.cmd, " ");
        String string = stringTokenizer.nextToken();
        if (string.equals("call_method")) {
            this.CallJavaMethod(stringTokenizer);
        } else if (string.equals("set_member")) {
            this.SetJavaMember(stringTokenizer);
        } else if (string.equals("get_member")) {
            this.GetJavaMember(stringTokenizer);
        } else if (string.equals("add_classpath")) {
            this.AddClassPath(stringTokenizer);
        } else if (string.equals("server_type")) {
            this.ServerType(stringTokenizer);
        } else if (string.equals("report")) {
            this.Report(stringTokenizer);
        } else if (string.equals("isa")) {
            this.IsA(stringTokenizer);
        } else if (string.equals("create_object")) {
            this.CreateJavaObject(stringTokenizer);
        } else if (string.equals("delete_object")) {
            this.DeleteJavaObject(stringTokenizer);
        } else if (string.equals("obj_cnt")) {
            this.ObjectCount(stringTokenizer);
        } else if (string.equals("die")) {
            InlineJavaUtils.debug(1, "received a request to die...");
            System.exit(0);
        } else {
            throw new InlineJavaException("Unknown command " + string);
        }
    }

    void Report(StringTokenizer stringTokenizer) throws InlineJavaException {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
        stringTokenizer2.nextToken();
        StringTokenizer stringTokenizer3 = new StringTokenizer(this.Decode(stringTokenizer2.nextToken()), " ");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer3.hasMoreTokens()) {
            String string = stringTokenizer3.nextToken();
            arrayList.add(arrayList.size(), string);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Class<Object> clazz;
            Object object;
            Object object2;
            AccessibleObject accessibleObject;
            int n;
            String string = (String)arrayList.get(i);
            Class clazz2 = this.ijc.ValidateClass(string);
            InlineJavaUtils.debug(3, "reporting for " + clazz2);
            stringBuffer.append("class " + clazz2.getName() + "\n");
            Constructor<?>[] constructorArray = clazz2.getConstructors();
            Method[] methodArray = clazz2.getMethods();
            Field[] fieldArray = clazz2.getFields();
            int n2 = clazz2.getModifiers() & 1;
            if (n2 != 0 && clazz2.getDeclaredConstructors().length == 0) {
                String string2 = InlineJavaUtils.CreateSignature(new Class[0]);
                stringBuffer.append("constructor " + string2 + "\n");
            }
            for (n = 0; n < constructorArray.length; ++n) {
                accessibleObject = constructorArray[n];
                object2 = ((Constructor)accessibleObject).getParameterTypes();
                object = InlineJavaUtils.CreateSignature(object2);
                clazz = ((Constructor)accessibleObject).getDeclaringClass();
                stringBuffer.append("constructor " + (String)object + "\n");
            }
            for (n = 0; n < methodArray.length; ++n) {
                accessibleObject = methodArray[n];
                object2 = Modifier.isStatic(((Method)accessibleObject).getModifiers()) ? " static " : " instance ";
                object = InlineJavaUtils.CreateSignature(((Method)accessibleObject).getParameterTypes());
                clazz = ((Method)accessibleObject).getDeclaringClass();
                stringBuffer.append("method" + (String)object2 + clazz.getName() + " " + ((Method)accessibleObject).getName() + (String)object + "\n");
            }
            for (n = 0; n < fieldArray.length; ++n) {
                accessibleObject = fieldArray[InlineJavaUtils.ReverseMembers() ? fieldArray.length - 1 - n : n];
                object2 = Modifier.isStatic(((Field)accessibleObject).getModifiers()) ? " static " : " instance ";
                object = ((Field)accessibleObject).getDeclaringClass();
                clazz = ((Field)accessibleObject).getType();
                stringBuffer.append("field" + (String)object2 + ((Class)object).getName() + " " + ((Field)accessibleObject).getName() + " " + clazz.getName() + "\n");
            }
        }
        this.SetResponse(stringBuffer.toString());
    }

    void AddClassPath(StringTokenizer stringTokenizer) throws InlineJavaException {
        while (stringTokenizer.hasMoreTokens()) {
            String string = this.Decode(stringTokenizer.nextToken());
            InlineJavaServer.GetInstance().GetUserClassLoader().AddClassPath(string);
        }
        this.SetResponse(null);
    }

    void ServerType(StringTokenizer stringTokenizer) throws InlineJavaException {
        this.SetResponse(this.ijs.GetType());
    }

    void IsA(StringTokenizer stringTokenizer) throws InlineJavaException {
        String string = stringTokenizer.nextToken();
        Class clazz = this.ijc.ValidateClass(string);
        String string2 = stringTokenizer.nextToken();
        Class clazz2 = this.ijc.ValidateClass(string2);
        this.SetResponse(new Integer(this.ijc.DoesExtend(clazz, clazz2)));
    }

    void ObjectCount(StringTokenizer stringTokenizer) throws InlineJavaException {
        this.SetResponse(new Integer(this.ijs.ObjectCount()));
    }

    void CreateJavaObject(StringTokenizer stringTokenizer) throws InlineJavaException {
        String string = stringTokenizer.nextToken();
        Class clazz = this.ijc.ValidateClass(string);
        if (!this.ijc.ClassIsArray(clazz)) {
            ArrayList arrayList = this.ValidateMethod(true, clazz, string, stringTokenizer);
            Object[] objectArray = (Object[])arrayList.get(1);
            Class[] classArray = (Class[])arrayList.get(2);
            try {
                Object object = this.CreateObject(clazz, objectArray, classArray);
                this.SetResponse(object);
            }
            catch (InlineJavaInvocationTargetException inlineJavaInvocationTargetException) {
                Throwable throwable = inlineJavaInvocationTargetException.GetThrowable();
                if (throwable instanceof InlineJavaException) {
                    InlineJavaException inlineJavaException = (InlineJavaException)throwable;
                    throw inlineJavaException;
                }
                this.SetResponse(new InlineJavaThrown(throwable));
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (stringBuffer.toString().startsWith("[")) {
                stringBuffer.replace(0, 1, "");
            }
            if (stringBuffer.toString().startsWith("L")) {
                stringBuffer.replace(0, 1, "");
                stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "");
            }
            Class clazz2 = this.ijc.ValidateClass(stringBuffer.toString());
            InlineJavaUtils.debug(4, "array elements: " + clazz2.getName());
            Object object = this.ija.CreateArray(clazz2, stringTokenizer);
            this.SetResponse(object);
        }
    }

    void CallJavaMethod(StringTokenizer stringTokenizer) throws InlineJavaException {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        String string = stringTokenizer.nextToken();
        Object object = null;
        if (n > 0) {
            object = this.ijs.GetObject(n);
            string = object.getClass().getName();
        }
        Class clazz = this.ijc.ValidateClass(string);
        String string2 = stringTokenizer.nextToken();
        if (this.ijc.ClassIsArray(clazz) && string2.equals("getLength")) {
            int n2 = Array.getLength(object);
            this.SetResponse(new Integer(n2));
        } else {
            ArrayList arrayList = this.ValidateMethod(false, clazz, string2, stringTokenizer);
            Method method = (Method)arrayList.get(0);
            String string3 = method.getName();
            Object[] objectArray = (Object[])arrayList.get(1);
            try {
                Object object2 = InlineJavaServer.GetInstance().GetUserClassLoader().invoke(method, object, objectArray);
                this.SetResponse(object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InlineJavaException("You are not allowed to invoke method " + string3 + " in class " + string + ": " + illegalAccessException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InlineJavaException("Arguments for method " + string3 + " in class " + string + " are incompatible: " + illegalArgumentException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                String string4 = throwable.getClass().getName();
                String string5 = throwable.getMessage();
                InlineJavaUtils.debug(1, "method " + string3 + " in class " + string + " threw exception " + string4 + ": " + string5);
                if (throwable instanceof InlineJavaException) {
                    InlineJavaException inlineJavaException = (InlineJavaException)throwable;
                    throw inlineJavaException;
                }
                this.SetResponse(new InlineJavaThrown(throwable));
            }
        }
    }

    void SetJavaMember(StringTokenizer stringTokenizer) throws InlineJavaException {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        String string = stringTokenizer.nextToken();
        Object object = null;
        if (n > 0) {
            object = this.ijs.GetObject(n);
            string = object.getClass().getName();
        }
        Class clazz = this.ijc.ValidateClass(string);
        String string2 = stringTokenizer.nextToken();
        if (this.ijc.ClassIsArray(clazz)) {
            int n2 = Integer.parseInt(string2);
            Class clazz2 = this.ijc.ValidateClass(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken();
            String string4 = "For array of type " + clazz.getName() + ", element " + string2 + ": ";
            try {
                Object object2 = this.ijc.CastArgument(clazz2, string3);
                InlineJavaServer.GetInstance().GetUserClassLoader().array_set(object, n2, object2);
                this.SetResponse(null);
            }
            catch (InlineJavaCastException inlineJavaCastException) {
                throw new InlineJavaCastException(string4 + inlineJavaCastException.getMessage());
            }
            catch (InlineJavaException inlineJavaException) {
                throw new InlineJavaException(string4 + inlineJavaException.getMessage());
            }
        }
        ArrayList arrayList = this.ValidateMember(clazz, string2, stringTokenizer);
        Field field = (Field)arrayList.get(0);
        String string5 = field.getName();
        Object e = arrayList.get(1);
        try {
            InlineJavaServer.GetInstance().GetUserClassLoader().set(field, object, e);
            this.SetResponse(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InlineJavaException("You are not allowed to set member " + string5 + " in class " + string + ": " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InlineJavaException("Argument for member " + string5 + " in class " + string + " is incompatible: " + illegalArgumentException.getMessage());
        }
    }

    void GetJavaMember(StringTokenizer stringTokenizer) throws InlineJavaException {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        String string = stringTokenizer.nextToken();
        Object object = null;
        if (n > 0) {
            object = this.ijs.GetObject(n);
            string = object.getClass().getName();
        }
        Class clazz = this.ijc.ValidateClass(string);
        String string2 = stringTokenizer.nextToken();
        if (this.ijc.ClassIsArray(clazz)) {
            int n2 = Integer.parseInt(string2);
            Object object2 = InlineJavaServer.GetInstance().GetUserClassLoader().array_get(object, n2);
            this.SetResponse(object2);
        } else {
            ArrayList arrayList = this.ValidateMember(clazz, string2, stringTokenizer);
            Field field = (Field)arrayList.get(0);
            String string3 = field.getName();
            try {
                Object object3 = InlineJavaServer.GetInstance().GetUserClassLoader().get(field, object);
                this.SetResponse(object3);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InlineJavaException("You are not allowed to set member " + string3 + " in class " + string + ": " + illegalAccessException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InlineJavaException("Argument for member " + string3 + " in class " + string + " is incompatible: " + illegalArgumentException.getMessage());
            }
        }
    }

    void DeleteJavaObject(StringTokenizer stringTokenizer) throws InlineJavaException {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        Object object = this.ijs.DeleteObject(n);
        this.SetResponse(null);
    }

    Object CreateObject(Class clazz, Object[] objectArray, Class[] classArray) throws InlineJavaException {
        clazz = this.ijc.FindWrapper(clazz);
        String string = clazz.getName();
        Object object = null;
        try {
            object = InlineJavaServer.GetInstance().GetUserClassLoader().create(clazz, objectArray, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InlineJavaException("Constructor for class " + string + " with signature " + InlineJavaUtils.CreateSignature(classArray) + " not found: " + noSuchMethodException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new InlineJavaException("You are not allowed to instantiate object of class " + string + ": " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InlineJavaException("You are not allowed to instantiate object of class " + string + " using the constructor with signature " + InlineJavaUtils.CreateSignature(classArray) + ": " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InlineJavaException("Arguments to constructor for class " + string + " with signature " + InlineJavaUtils.CreateSignature(classArray) + " are incompatible: " + illegalArgumentException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string2 = throwable.getClass().getName();
            String string3 = throwable.getMessage();
            throw new InlineJavaInvocationTargetException("Constructor for class " + string + " with signature " + InlineJavaUtils.CreateSignature(classArray) + " threw exception " + string2 + ": " + string3, throwable);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ArrayList ValidateMethod(boolean bl, Class clazz, String string, StringTokenizer stringTokenizer) throws InlineJavaException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = stringTokenizer.nextToken();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(arrayList2.size(), stringTokenizer.nextToken());
        }
        String string3 = clazz.getName() + "." + string + string2;
        ArrayList<Member> arrayList3 = new ArrayList<Member>();
        Class[] classArray = null;
        Member member = (Member)member_cache.get(string3);
        if (member != null) {
            InlineJavaUtils.debug(3, "method was cached");
            arrayList3.add(arrayList3.size(), member);
        } else {
            Member[] memberArray = bl ? (Member[])clazz.getConstructors() : (Member[])clazz.getMethods();
            for (int i = 0; i < memberArray.length; ++i) {
                Member member2 = memberArray[i];
                if (!member2.getName().equals(string)) continue;
                InlineJavaUtils.debug(3, "found a " + string + (bl ? " constructor" : " method"));
                classArray = bl ? ((Constructor)member2).getParameterTypes() : ((Method)member2).getParameterTypes();
                String string4 = InlineJavaUtils.CreateSignature(classArray, ",");
                InlineJavaUtils.debug(3, string4 + " = " + string2 + "?");
                if (!string2.equals(string4)) continue;
                InlineJavaUtils.debug(3, "has matching signature " + string4);
                arrayList3.add(arrayList3.size(), member2);
                member_cache.put(string3, member2);
                break;
            }
        }
        if (arrayList3.size() == 0) {
            if (!bl || !string2.equals("()")) throw new InlineJavaException((bl ? "Constructor " : "Method ") + string + " for class " + clazz.getName() + " with signature " + string2 + " not found");
            arrayList.add(0, null);
            arrayList.add(1, new Object[0]);
            arrayList.add(2, new Class[0]);
            return arrayList;
        }
        if (arrayList3.size() != 1) return arrayList;
        Member member3 = (Member)arrayList3.get(0);
        classArray = bl ? ((Constructor)member3).getParameterTypes() : ((Method)member3).getParameterTypes();
        String string5 = "In method " + string + " of class " + clazz.getName() + ": ";
        try {
            arrayList.add(0, member3);
            arrayList.add(1, this.ijc.CastArguments(classArray, arrayList2));
            arrayList.add(2, classArray);
            return arrayList;
        }
        catch (InlineJavaCastException inlineJavaCastException) {
            throw new InlineJavaCastException(string5 + inlineJavaCastException.getMessage());
        }
        catch (InlineJavaException inlineJavaException) {
            throw new InlineJavaException(string5 + inlineJavaException.getMessage());
        }
    }

    ArrayList ValidateMember(Class clazz, String string, StringTokenizer stringTokenizer) throws InlineJavaException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = string2 + " " + clazz.getName() + "." + string;
        ArrayList<Member> arrayList2 = new ArrayList<Member>();
        Class<?> clazz2 = null;
        Member member = (Member)member_cache.get(string4);
        if (member != null) {
            InlineJavaUtils.debug(3, "member was cached");
            arrayList2.add(arrayList2.size(), member);
        } else {
            object = clazz.getFields();
            for (int i = 0; i < ((Field[])object).length; ++i) {
                Field field = object[InlineJavaUtils.ReverseMembers() ? ((Field[])object).length - 1 - i : i];
                if (!field.getName().equals(string)) continue;
                InlineJavaUtils.debug(3, "found a " + string + " member");
                clazz2 = field.getType();
                String string5 = clazz2.getName();
                if (!string2.equals(string5)) continue;
                InlineJavaUtils.debug(3, "has matching type " + string5);
                arrayList2.add(arrayList2.size(), field);
            }
        }
        if (arrayList2.size() == 0) {
            throw new InlineJavaException("Member " + string + " of type " + string2 + " for class " + clazz.getName() + " not found");
        }
        object = (Field)arrayList2.get(arrayList2.size() - 1);
        member_cache.put(string4, object);
        clazz2 = ((Field)object).getType();
        String string6 = "For member " + string + " of class " + clazz.getName() + ": ";
        try {
            arrayList.add(0, object);
            arrayList.add(1, this.ijc.CastArgument(clazz2, string3));
            arrayList.add(2, clazz2);
        }
        catch (InlineJavaCastException inlineJavaCastException) {
            throw new InlineJavaCastException(string6 + inlineJavaCastException.getMessage());
        }
        catch (InlineJavaException inlineJavaException) {
            throw new InlineJavaException(string6 + inlineJavaException.getMessage());
        }
        return arrayList;
    }

    void SetResponse(Object object) throws InlineJavaException {
        this.response = "ok " + this.SerializeObject(object);
    }

    String SerializeObject(Object object) throws InlineJavaException {
        if (object == null) {
            return "undef:";
        }
        if (this.ijc.ClassIsNumeric(object.getClass()) || this.ijc.ClassIsChar(object.getClass()) || this.ijc.ClassIsString(object.getClass())) {
            return "scalar:" + this.Encode(object.toString());
        }
        if (this.ijc.ClassIsBool(object.getClass())) {
            String string = object.toString();
            return "scalar:" + this.Encode(string.equals("true") ? "1" : "0");
        }
        boolean bl = false;
        if (object instanceof InlineJavaThrown) {
            bl = true;
            object = ((InlineJavaThrown)object).GetThrowable();
        }
        int n = this.ijs.PutObject(object);
        return "object:" + (bl ? "1" : "0") + ":" + String.valueOf(n) + ":" + object.getClass().getName();
    }

    String Decode(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = (char)Integer.parseInt(string2);
            stringBuffer.append(new String(new char[]{c}));
        }
        return stringBuffer.toString();
    }

    String Encode(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append((int)cArray[i]);
        }
        return stringBuffer.toString();
    }

    String GetResponse() {
        return this.response;
    }
}

