/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.direct;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.concurrent.Semaphore;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_display_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_lock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_unlock_callback_t;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.DefaultMediaPlayer;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;

public class DefaultDirectMediaPlayer
extends DefaultMediaPlayer
implements DirectMediaPlayer {
    private final Semaphore semaphore = new Semaphore(1);
    private final String format;
    private final int width;
    private final int height;
    private final int pitch;
    private final RenderCallback renderCallback;
    private final Memory nativeBuffer;
    private final libvlc_lock_callback_t lock;
    private final libvlc_unlock_callback_t unlock;
    private final libvlc_display_callback_t display;

    public DefaultDirectMediaPlayer(LibVlc libvlc, libvlc_instance_t instance, String format, int width, int height, int pitch, RenderCallback renderCallback) {
        super(libvlc, instance);
        this.format = format;
        this.width = width;
        this.height = height;
        this.pitch = pitch;
        this.renderCallback = renderCallback;
        this.nativeBuffer = new Memory((long)(width * height * 4 + 32)).align(32);
        this.lock = new libvlc_lock_callback_t(){

            public Pointer lock(Pointer opaque, Pointer plane) {
                Logger.trace("lock", new Object[0]);
                Logger.trace("acquire", new Object[0]);
                DefaultDirectMediaPlayer.this.semaphore.acquireUninterruptibly();
                Logger.trace("acquired", new Object[0]);
                plane.setPointer(0L, (Pointer)DefaultDirectMediaPlayer.this.nativeBuffer);
                Logger.trace("lock finished", new Object[0]);
                return null;
            }
        };
        this.unlock = new libvlc_unlock_callback_t(){

            public void unlock(Pointer opaque, Pointer picture, Pointer plane) {
                Logger.trace("unlock", new Object[0]);
                Logger.trace("release", new Object[0]);
                DefaultDirectMediaPlayer.this.semaphore.release();
                Logger.trace("released", new Object[0]);
                Logger.trace("unlock finished", new Object[0]);
            }
        };
        this.display = new libvlc_display_callback_t(){

            public void display(Pointer opaque, Pointer picture) {
                Logger.trace("display", new Object[0]);
                DefaultDirectMediaPlayer.this.renderCallback.display(DefaultDirectMediaPlayer.this.nativeBuffer);
                Logger.trace("display finished", new Object[0]);
            }
        };
        libvlc.libvlc_video_set_format(this.mediaPlayerInstance(), format, width, height, pitch);
        libvlc.libvlc_video_set_callbacks(this.mediaPlayerInstance(), this.lock, this.unlock, this.display, null);
    }

    public String format() {
        return this.format;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int pitch() {
        return this.pitch;
    }
}

