/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;

public class MultipartResponse {
    private static final String BOUNDARY_TEXT = "End";
    HttpServletResponse res;
    PrintWriter out;
    OutputStream outputStream;
    boolean endedLastResponse = true;

    public MultipartResponse(HttpServletResponse response) throws IOException {
        this.res = response;
        this.outputStream = response.getOutputStream();
        this.out = new PrintWriter(this.outputStream, true);
        this.res.setContentType("multipart/byteranges; boundary=End");
        this.out.println();
        this.out.println("--End");
    }

    public void startResponse(String contentType) throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("already called finish()");
        }
        if (!this.endedLastResponse) {
            this.endResponse();
        }
        this.out.println("Content-Type: " + contentType);
        this.out.println();
        this.endedLastResponse = false;
    }

    public void endResponse() throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("already called finish()");
        }
        this.out.println();
        this.out.println("--End");
        this.out.flush();
        this.outputStream.flush();
        this.endedLastResponse = true;
    }

    public void finish() throws IOException {
        if (this.out == null) {
            throw new IllegalStateException("already called finish()");
        }
        this.out.println("--End--");
        this.out.flush();
        this.outputStream.flush();
        this.out = null;
        this.outputStream = null;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

