/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.notepad;

import com.darwinsys.io.FileSaver;
import com.darwinsys.swingui.UtilGUI;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.prefs.Preferences;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintServiceLookup;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class Notepad {
    private JFrame theFrame;
    private JTextArea ta;
    private UndoManager undoManager;
    private JFileChooser chooser;
    private String fileName;
    private static List<Notepad> windows = new ArrayList<Notepad>();
    private boolean isStandalone = true;
    private JMenu fm;
    private JMenu em;
    private JMenu hm;
    private FileSaver fileSaver;
    protected boolean dirty;
    protected Preferences prefsNode = Preferences.userNodeForPackage(this.getClass());
    Action openAction = new AbstractAction("Open"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal;
            if (Notepad.this.chooser == null) {
                Notepad.this.chooser = new JFileChooser();
            }
            if ((returnVal = Notepad.this.chooser.showOpenDialog(Notepad.this.theFrame)) == 0) {
                File file = Notepad.this.chooser.getSelectedFile();
                try {
                    Notepad.this.doLoad(file.getAbsolutePath());
                }
                catch (IOException e1) {
                    Notepad.this.error("Can't open file", e1);
                }
            }
        }
    };
    Action newAction = new AbstractAction("New"){

        @Override
        public void actionPerformed(ActionEvent e) {
            new Notepad();
        }
    };
    private boolean doingSaveAs;
    Action saveAction = new AbstractAction("Save"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                Notepad.this.doSave();
            }
            catch (IOException e) {
                Notepad.this.error("Can't save file", e);
            }
        }
    };
    Action saveAsAction = new SaveAsAction();
    Action closeAction = new CloseAction();
    Action printAction = new PrintAction();
    Action cutAction = new CutAction();
    Action undoAction = new UndoAction();
    Action copyAction = new CopyAction();
    Action pasteAction = new PasteAction();
    Action exitAction = new ExitAction();
    Action helpAboutAction = new HelpAboutAction();

    public Notepad() {
        this(true);
    }

    public Notepad(boolean isStandalone) {
        this(Preferences.userNodeForPackage(Notepad.class), isStandalone);
    }

    public Notepad(Preferences prefs) {
        this(prefs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notepad(Preferences prefs, boolean isStandalone) {
        this.prefsNode = prefs;
        this.isStandalone = isStandalone;
        String prop = System.getProperty("STANDALONE");
        if (prop != null) {
            this.isStandalone = Boolean.parseBoolean(prop);
        }
        this.theFrame = new JFrame();
        this.theFrame.setDefaultCloseOperation(0);
        this.theFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Notepad.this.closeThisWindow();
            }
        });
        UtilGUI.monitorWindowPosition(this.theFrame, this.prefsNode);
        this.ta = new JTextArea(30, 70);
        this.undoManager = new UndoManager();
        Document document = this.ta.getDocument();
        document.addUndoableEditListener(this.undoManager);
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                Notepad.this.setDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Notepad.this.setDirty(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Notepad.this.setDirty(true);
            }
        });
        this.ta.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent ev) {
                if (ev.isControlDown() && ev.getKeyChar() == '\u0013') {
                    try {
                        Notepad.this.doSave();
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Notepad.this.theFrame, e.toString(), "Error!", 0);
                    }
                }
            }
        });
        this.theFrame.setContentPane(new JScrollPane(this.ta));
        this.theFrame.pack();
        this.createMenus();
        Point loc = this.theFrame.getLocation();
        List<Notepad> list = windows;
        synchronized (list) {
            int windowsCreated = windows.size();
            loc.x += windowsCreated * 20;
            loc.y += windowsCreated * 20;
            windows.add(this);
        }
        this.theFrame.setLocation(loc);
        this.theFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeThisWindow() {
        Object[] options = new String[]{"Save", "Discard", "Cancel"};
        int ret = JOptionPane.showOptionDialog(this.theFrame, "You have unsaved changes", "Warning", 0, 0, null, options, options[0]);
        switch (ret) {
            case -1: 
            case 2: {
                return;
            }
            case 0: {
                try {
                    this.doSave(this.fileName);
                    break;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.theFrame, "That didn't work: " + ex);
                    return;
                }
            }
        }
        this.theFrame.setVisible(false);
        this.theFrame.dispose();
        List<Notepad> list = windows;
        synchronized (list) {
            windows.remove(this);
            if (windows.size() == 0 && this.isStandalone) {
                System.exit(0);
            }
        }
    }

    private void error(String message, Exception e) {
        JOptionPane.showMessageDialog(this.theFrame, message + "\n" + e);
        e.printStackTrace();
    }

    private void createMenus() {
        JMenuBar mb = new JMenuBar();
        this.theFrame.setJMenuBar(mb);
        this.fm = new JMenu("File");
        this.fm.add(this.openAction);
        this.fm.add(this.saveAction);
        ((JMenuItem)this.fm.getMenuComponent(1)).setMnemonic(83);
        this.fm.add(this.saveAsAction);
        this.fm.add(this.closeAction);
        this.fm.add(this.newAction);
        this.fm.addSeparator();
        this.fm.add(this.printAction);
        this.fm.addSeparator();
        this.fm.add(this.exitAction);
        this.exitAction.setEnabled(this.isStandalone);
        mb.add(this.fm);
        this.em = new JMenu("Edit");
        this.em.setMnemonic(69);
        this.em.add(this.cutAction);
        ((JMenuItem)this.em.getMenuComponent(0)).setMnemonic(88);
        this.em.add(this.copyAction);
        ((JMenuItem)this.em.getMenuComponent(1)).setMnemonic(67);
        this.em.add(this.pasteAction);
        this.em.add(this.undoAction);
        ((JMenuItem)this.em.getMenuComponent(3)).setMnemonic(90);
        this.em.addSeparator();
        JMenuItem mi = new JMenuItem("Search");
        mi.setEnabled(false);
        this.em.add(mi);
        mi = new JMenuItem("Replace");
        mi.setEnabled(false);
        this.em.add(mi);
        this.em.addSeparator();
        JMenu insertMenu = new JMenu("Insert");
        this.em.add(insertMenu);
        JMenuItem menuItem = new JMenuItem("Date");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.ta.insert(new Date().toString(), Notepad.this.ta.getCaretPosition());
            }
        });
        ((Container)insertMenu).add(menuItem);
        JMenuItem menuItem2 = new JMenuItem(".signature");
        menuItem2.setEnabled(false);
        ((Container)insertMenu).add(menuItem2);
        JMenuItem menuItem3 = new JMenuItem("File...");
        menuItem3.setEnabled(false);
        ((Container)insertMenu).add(menuItem3);
        mb.add(this.em);
        this.hm = new JMenu("Help");
        this.hm.add(this.helpAboutAction);
        this.helpAboutAction.setEnabled(this.isStandalone);
        mb.add(this.hm);
    }

    public final void doPrint() throws IOException, PrintException {
        int i;
        System.out.println("Printing ");
        DocFlavor.CHAR_ARRAY flavor = DocFlavor.CHAR_ARRAY.TEXT_PLAIN;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        Object[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
        switch (pservices.length) {
            case 0: {
                JOptionPane.showMessageDialog(this.theFrame, "Error: No PrintService Found", "Error", 0);
                return;
            }
            case 1: {
                i = 1;
                break;
            }
            default: {
                i = JOptionPane.showOptionDialog(this.theFrame, "Pick a printer", "Choice", 0, 3, null, pservices, pservices[0]);
            }
        }
        if (i < 0) {
            return;
        }
        DocPrintJob pj = pservices[i].createPrintJob();
        MyDocument doc = new MyDocument(flavor);
        pj.print(doc, aset);
    }

    public final void doNew() {
        this.fileName = null;
        this.dirty = false;
        this.ta.setText("");
    }

    public final void doLoad(File file) throws IOException {
        this.doLoad(file.getAbsolutePath());
    }

    public final void doLoad(String fileName) throws IOException {
        String line;
        BufferedReader is = null;
        try {
            is = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.theFrame, String.format("File %s not found, treating as New File", fileName), "Not found", 2);
            this.setFileName(fileName);
            return;
        }
        while ((line = is.readLine()) != null) {
            this.ta.append(line);
            this.ta.append("\n");
        }
        this.ta.setCaretPosition(0);
        is.close();
        this.setFileName(fileName);
    }

    private void doSave() throws IOException {
        int returnVal;
        if (this.fileName != null) {
            this.doSave(this.fileName);
            return;
        }
        boolean bl = this.doingSaveAs = this.fileName != null;
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        if ((returnVal = this.chooser.showOpenDialog(this.theFrame)) == 0) {
            File file = this.chooser.getSelectedFile();
            if (file.exists() && this.doingSaveAs) {
                int ret = JOptionPane.showConfirmDialog(this.theFrame, "File already exists, overwrite?", "File Exists", 0);
                System.err.println(ret);
                if (ret != 0) {
                    return;
                }
            }
            this.doSave(file);
        }
    }

    public final void doSave(String fileName) throws IOException {
        this.doSave(new File(fileName));
    }

    public final void doSave(File file) throws IOException {
        String line;
        if (this.fileSaver == null || !this.fileSaver.getFile().equals(file)) {
            this.fileSaver = new FileSaver(file);
        }
        PrintWriter w = new PrintWriter(this.fileSaver.getWriter());
        BufferedReader is = new BufferedReader(new StringReader(this.ta.getText()));
        while ((line = is.readLine()) != null) {
            w.println(line);
        }
        w.close();
        this.fileSaver.finish();
        this.setFileName(file.getAbsolutePath());
        this.setDirty(false);
        this.doingSaveAs = false;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.theFrame.setTitle(this.fileName + (dirty ? " (modified)" : ""));
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
        this.theFrame.setTitle(fileName);
    }

    public JMenu getFileMenu() {
        return this.fm;
    }

    public JMenu getHelpMenu() {
        return this.hm;
    }

    final class MyDocument
    implements Doc {
        private DocFlavor flavor;

        public MyDocument(DocFlavor flavor) {
            this.flavor = flavor;
        }

        @Override
        public DocFlavor getDocFlavor() {
            return this.flavor;
        }

        @Override
        public Object getPrintData() throws IOException {
            return Notepad.this.ta.getText();
        }

        @Override
        public DocAttributeSet getAttributes() {
            return null;
        }

        @Override
        public Reader getReaderForText() throws IOException {
            return new StringReader(Notepad.this.ta.getText());
        }

        @Override
        public InputStream getStreamForBytes() throws IOException {
            return null;
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        HelpAboutAction() {
            super("About");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Notepad.this.theFrame, "<html><font color='red'>Notepad 0.0</font> A simple text editor");
        }
    }

    static class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class PasteAction
    extends AbstractAction {
        PasteAction() {
            super("Paste");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Notepad.this.ta.paste();
        }
    }

    class CopyAction
    extends AbstractAction {
        CopyAction() {
            super("Copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Notepad.this.ta.copy();
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
            super("Undo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Notepad.this.undoManager.undo();
        }
    }

    class CutAction
    extends AbstractAction {
        CutAction() {
            super("Cut");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Notepad.this.ta.cut();
        }
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super("Print");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Notepad.this.doPrint();
            }
            catch (IOException e1) {
                Notepad.this.error("Print failure", e1);
            }
            catch (PrintException e1) {
                Notepad.this.error("Print failure", e1);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super("Close");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Notepad.this.closeThisWindow();
        }
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
            super("Save As");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Notepad.this.doingSaveAs = true;
            Notepad.this.saveAction.actionPerformed(e);
            Notepad.this.doingSaveAs = false;
        }
    }
}

