/*
 * Zademonstruj korzystanie ze wskaźników.
 */
#include <stdio.h>
#include <stdint.h>

int main()
{
    uint8_t smallThing = 5;     // Coś małego.
    uint8_t smallThing2 = 6;    // Też coś małego.
    uint64_t largeThing = 987654321; // Coś dużego.

    uint8_t* smallPtr;          // Wskaźnik do małej rzeczy.
    uint64_t* largePtr;         // Wskaźnik do dużej rzeczy.

    printf("smallThing %d\n", smallThing);
    printf("sizeof(smallThing) %lu\n", sizeof(smallThing));

    printf("largeThing %ld\n", largeThing);
    printf("sizeof(largeThing) %lu\n", sizeof(largeThing));

    smallPtr = &smallThing;     // Wskaźnik smallPtr wskazuje smallThing.

    printf("smallPtr %p\n", smallPtr);
    printf("sizeof(smallPtr) %lu\n", sizeof(smallPtr));
    printf("*smallPtr %d\n", *smallPtr);

    smallPtr = &smallThing2;    // Wskaźnik  smallPtr wskazuje smallThing2.
    printf("*smallPtr %d\n", *smallPtr);

    largePtr = &largeThing;
    printf("largePtr %p\n", largePtr);
    printf("sizeof(largePtr) %lu\n", sizeof(largePtr));
    printf("*largePtr %ld\n", *largePtr);

    return (0);
}
