// Niezmienna klasa wykorzystujca defensywne kopiowanie

import java.util.*;
import java.io.*;

public final class Period implements Serializable {
    private final Date start;
    private final Date end;

    /**
     * @param  start - pocztek odcinka czasu
     * @param  end - koniec odcinka czasu, nie moe by wczeniejszy ni start
     * @throws IllegalArgumentException jeeli start jest wikszy ni end
     * @throws NullPointerException jeeli start lub end ma warto null.
     */
    public Period(Date start, Date end) {
        this.start = new Date(start.getTime());
        this.end   = new Date(end.getTime());

        if (this.start.compareTo(this.end) > 0)
          throw new IllegalArgumentException(start +" > "+ end);
    }

    public Date start () { return (Date) start.clone(); }

    public Date end ()   { return (Date) end.clone(); }

    public String toString() { return start + " - " + end; }

    // ... // Pozostaa czc pominita

/* ZAKOMENTOWANE - Ta metoda readObject uniemoliwia atak typu BogusPeriod,
 * ale nie radzi sobie z atakiem MutablePeriod.

    private void readObject(ObjectInputStream s)
            throws IOException, ClassNotFoundException {
        s.defaultReadObject();

        // Sprawdzenie poprawnoci niezmiennikw
        if (start.compareTo(end) > 0)
            throw new InvalidObjectException(start +" po "+ end);
    }
*/

/* ZAKOMENTOWANE - Ta metoda readObject uniemoliwia zarwno atak typu
 * BogusPeriod jak i MutablePeriod.
 * Aby z niej skorzystac naley usun modyfikator final z pl start i
 * end.

    private void readObject(ObjectInputStream s)
            throws IOException, ClassNotFoundException {
        s.defaultReadObject();

        // Defensywne kopiowanie modyfikowalnych komponentw
        start = new Date(start.getTime());
        end   = new Date(end.getTime());

        // Sprawdzenie poprawnoci niezmiennikw
        if (start.compareTo(end) > 0)
            throw new InvalidObjectException(start +" po "+ end);
    }

 */


/* ZAKOMENTOWANE - Alternatywa dla defensywnej metody readObject,
 * defensywna metoda readResolve. Nie wymaga usunicia modyfikatorw
 * final z pl start i end.
 * Uniemoliwia ataki BogusPeriod i MutablePeriod.

    // Idiom defensywnego readResolve
    private Object readResolve() throws ObjectStreamException {
        return new Period(start, end);
    }

 */
}
