// Naruszona "niezmienno" klasy reprezentujcej odcinek czasu

import java.util.*;

public final class Period {
    private final Date start;
    private final Date end;

    /**
     * @param  start - pocztek odcinka czasu
     * @param  end - koniec odcinka czasu, nie moe by wczeniejszy ni start
     * @throws IllegalArgumentException jeeli start jest wikszy ni end
     * @throws NullPointerException jeeli start lub end ma warto null.
     *
     * Bd! - Wymaga defensywnego kopiowania parametrw
     */
    public Period(Date start, Date end) {
        if (start.compareTo(end) > 0)
            throw new IllegalArgumentException(start + " po " + end);
        this.start = start;
        this.end   = end;
    }


/* ZAKOMENTOWANE

    // Poprawiony konstruktor - defensywne kopiowanie parametrw
    public Period(Date start, Date end) {
        this.start = new Date(start.getTime());
        this.end   = new Date(end.getTime());

        if (this.start.compareTo(this.end) > 0)
            throw new IllegalArgumentException(start +" po "+ end);
    }

 */

    // Bd! - Wymaga defensywnego kopiowania wewntrznych pl
    public Date start() {
        return start;
    }
    public Date end() {
        return end;
    }

/* ZAKOMENTOWANE

    // Poprawiony akcesor - defensywne kopiowanie pl wewntrznych
    public Date start() {
        return (Date) start.clone();
    }

    public Date end() {
        return (Date) end.clone();
    }

 */

    public String toString() {
        return start + " - " + end;
    }

    // ...  // Pozostaa cz pominita
}
