/**
 * Cig bez rozrniania wielkoci znakw. Cig z oryginaln wielkoci znakw
 * jest dostpny przez metod toString, ale wielko ta jest ignorowana 
 * przy porwnywaniu.
 * Ta wersja implementuje interfejs Comparable
 */

import java.util.*;

public final class CaseInsensitiveString implements Comparable {
    private String s;

    public CaseInsensitiveString(String s) {
        if (s == null)
            throw new NullPointerException();
        this.s = s;
    }

    public boolean equals(Object o) {
        return o instanceof CaseInsensitiveString &&
            ((CaseInsensitiveString)o).s.equalsIgnoreCase(s);
    }

    // Pno inicjowana buforowana metoda hashCode
    private volatile int hashCode = 0;

    public int hashCode() {
        if (hashCode == 0)
            hashCode = s.toUpperCase().hashCode();

        return hashCode;
    }

    public int compareTo(Object o) {
        CaseInsensitiveString cis = (CaseInsensitiveString)o;
        return String.CASE_INSENSITIVE_ORDER.compare(s, cis.s);
    }

    public String toString() {
        return s;
    }

    // ...  // Pozostaa cz pominita

    static void main(String[] args) {
        // Drukuje kolejno argumenty
        CaseInsensitiveString ciArgs[] =
            new CaseInsensitiveString[args.length];
        for (int i = 0; i < ciArgs.length; i++)
            ciArgs[i] = new CaseInsensitiveString(args[i]);
        Arrays.sort(ciArgs);
        System.out.println(Arrays.asList(ciArgs));

        // Drukuje argumenty eliminujc powtrzenia
        Set s = new HashSet();
        for (int i=0; i < ciArgs.length; i++)
            s.add(ciArgs[i]);
        System.out.println(s);
    }
}
