// Klasa typu singleton z moliwici serializacji

import java.io.*;

public class Elvis {
    public static final Elvis INSTANCE = new Elvis();

    private Elvis() {
        // ...
    }

    // ...  // pozostaa cz pominita

    // metoda readResolve zapewnia zachowanie waciwoci singleton
    private Object readResolve() throws ObjectStreamException {
        /*
         * Zwraca jedyny obiekt Elvis i pozwala procesowi zbierania nieuytkw
         * na zajcie si dublujcymi si obiektami klasy Elvis.
         */
        return INSTANCE;
    }

    public static void main(String[] args) {
        System.out.println(Elvis.INSTANCE);
    }
}
