import java.util.*;

// Szablon biblioteki dostawcy
public abstract class Foo {
    // Mapuje klucz typu String na odpowiedni obiekt Class
    private static Map implementations = null;

    // Inicjalizacja map inicjalizacji podczas pierwszego wywoania
    private static synchronized void initMapIfNecessary() {
        if (implementations == null) {
            implementations = new HashMap();

            // aduje nazwy klas implementacji oraz klucze z pliku
            // Properties, zmienia nazwy na obiekty Class
            // za pomoc Class.forName i zapamituje mapowanie.
            // ...
        }
    }

    public static Foo getInstance(String key) {
        initMapIfNecessary();
        Class c = (Class) implementations.get(key);
        if (c == null)
            return new DefaultFoo();

        try {
            return (Foo) c.newInstance();
        } catch (Exception e) {
            return new DefaultFoo();
        }
    }

    public static void main(String[] args) {
        System.out.println(getInstance("NonexistentFoo"));
    }
}

class DefaultFoo extends Foo {
}
