// Klasa StringList z wasn postaci serializowan

import java.io.*;

public class StringList implements Serializable {
    private transient int size   = 0;
    private transient Entry head = null;

    // Nie jest ju Serializable!
    private static class Entry {
        String data;
        Entry  next;
        Entry  previous;
    }

    // Docza podany cig do listy
    public void add(String s) {
        Entry e = new Entry();
        e.data = s;
        e.next = head;
        if (head != null)
            head.previous = e;
        head = e;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (Entry e=head; e!=null; e = e.next) {
            b.append(e.data);
            b.append(" ");
        }
        return b.toString();
    }

    /**
     * Serializacja tego obiektu <tt>StringList</tt>.
     *
     * @serialData Rozmiar przesyanej listy (ilo zawartych w niej cigw)
     * (<tt>int</tt>), po ktrym nastpuj wszystkie jej elementy
     * (kady to <tt>String</tt>), w odpowiedniej kolejnoci.
     */
    private void writeObject(ObjectOutputStream s)
            throws IOException {
        s.defaultWriteObject();
        s.writeInt(size);

        // Zapisanie wszystkich elementw o odpowiedniej kolejnoci.
        for (Entry e = head; e != null; e = e.next)
            s.writeObject(e.data);
    }

    private void readObject(ObjectInputStream s)
            throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();

        // Odczytanie wszystkich elementw i wstawienie ich do listy
        for (int i = 0; i < size; i++)
            add((String)s.readObject());
    }

    // ... // Pozostaa cz pominita
}
