import java.util.*;

public abstract class WorkQueue {
    private final List queue = new LinkedList();
    private boolean stopped = false;

    protected WorkQueue() { new WorkerThread().start(); }

    public final void enqueue(Object workItem) {
        synchronized (queue) {
            queue.add(workItem);
            queue.notify();
        }
    }

    public final void stop()  {
        synchronized (queue) {
            stopped = true;
            queue.notify();
        }
    }
    protected abstract void processItem(Object workItem)
        throws InterruptedException;

    // Bd - wywoanie metody obcej w bloku synchronizowanym!
    private class WorkerThread extends Thread {
        public void run() {
            while (true) {  // Gwna ptla
                synchronized (queue) {
                    try {
                        while (queue.isEmpty() && !stopped)
                            queue.wait();
                    } catch (InterruptedException e) {
                        return;
                    }

                    if (stopped)
                        return;

                    Object workItem = queue.remove(0);
                    try {
                        processItem(workItem); // Naoona blokada!
                    } catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }

/* ZAKOMENTOWANE

    // Obca metoda poza blokiem synchronizowanym
    private class WorkerThread extends Thread {
        public void run() {
            while (true) {  // Gwna ptla
                Object workItem = null;
                synchronized (queue) {
                    try {
                        while (queue.isEmpty() && !stopped)
                            queue.wait();
                    } catch (InterruptedException e) {
                        return;
                    }
                    if (stopped)
                        return;
                    workItem = queue.remove(0);
                }
                try {
                    processItem(workItem); // Brak blokady
                } catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

*/

}
