// Serializowalny rozszerzalny bezpieczny typ wyliczeniowy

import java.io.*;

public abstract class Operation implements Serializable {
    private final transient String name;
    protected Operation(String name) { this.name = name; }

    public static Operation PLUS = new Operation("+") {
        protected double eval(double x, double y) { return x+y; }
    };
    public static Operation MINUS = new Operation("-") {
        protected double eval(double x, double y) { return x-y; }
    };
    public static Operation TIMES = new Operation("*") {
        protected double eval(double x, double y) { return x*y; }
    };
    public static Operation DIVIDE = new Operation("/") {
        protected double eval(double x, double y) { return x/y; }
    };

    // Wykonaj operacj matematyczn dla biecego kontekstu
    protected abstract double eval(double x, double y);

    public String toString() { return this.name; }
    // Zablokowanie moliwoci przedefiniowywania Object.equals przez klasy pochodne 
    public final boolean equals(Object that) {
        return super.equals(that);
    }
    public final int hashCode() {
        return super.hashCode(); 
    }

    // 4 ponisze deklaracje s niezbdne dla serializacji
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;
    private static final Operation[] VALUES = { PLUS, MINUS, TIMES, DIVIDE };
    Object readResolve() throws ObjectStreamException {
        return VALUES[ordinal];  // Zmiana na posta kanoniczn
    }
}
