class DeadlockQueue extends WorkQueue {
    protected void processItem(final Object workItem)
            throws InterruptedException {
        // Tworzenie nowego wtku zwracajcego workItem do kolejki
        Thread child = new Thread() {
            public void run() { enqueue(workItem); }
        };
        child.start();
        child.join(); // Zakleszczenie!

        // Nie zostanie wydrukowane (chyba, e zostanie poprawiona wersja WorkerThread
        System.out.println(workItem);
    }

    public static void main(String[] args) throws InterruptedException {
        WorkQueue queue = new DeadlockQueue();
        for (int i = 0; i < args.length; i++)
            queue.enqueue(args[i]);

        // Oczekiwanie na elementy do wydruku i zatrzymanie kolejki
        Thread.sleep(1000);
        queue.stop();
    }
}
