// Konkretyzacja refleksyjna z dostpem przez interfejs

import java.util.*;

public class LimitedReflection {
    public static void main(String[] args) {
        // Zmiana nazwy klasy na obiekt Class
        Class cl = null;
        try {
            cl = Class.forName(args[0]);
        } catch(ClassNotFoundException e) {
            System.err.println("Nie znaleziono klasy.");
            System.exit(1);
        }

        // Konkretyzacja obiektu
        Set s = null;
        try {
            s = (Set) cl.newInstance();
        } catch(IllegalAccessException e) {
            System.err.println("Klasa niedostpna.");
            System.exit(1);
        } catch(InstantiationException e) {
            System.err.println("Bd tworzenia obiektu klasy.");
            System.exit(1);
        }

        // Wypisanie zawartoci zbioru
        s.addAll(Arrays.asList(args).subList(1, args.length-1));
        System.out.println(s);
    }
}
