/**
 * Cig bez rozrniania wielkoci znakw. Cig z oryginaln wielkoci znakw
 * jest dostpny przez metod toString, ale wielko ta jest ignorowana 
 * przy porwnywaniu
 */

public final class CaseInsensitiveString {
    private String s;

    public CaseInsensitiveString(String s) {
        if (s == null)
            throw new NullPointerException();
        this.s = s;
    }

    // Bd - naruszona symetria
    public boolean equals(Object o) {
        if (o instanceof CaseInsensitiveString)
            return s.equalsIgnoreCase(
                ((CaseInsensitiveString)o).s);
        if (o instanceof String)  // Wsppraca jednokierunkowa!
            return s.equalsIgnoreCase((String)o);
        return false;
    }

/*  WYKOMENTOWANE!!

    // Poprawione
    public boolean equals(Object o) {
        return o instanceof CaseInsensitiveString &&
            ((CaseInsensitiveString)o).s.equalsIgnoreCase(s);
    }

*/

    // ...  // Pozostaa cz pominita
    // Potrzebna bdzie rwnie metoda hashCode

    static void main(String[] args) {
        CaseInsensitiveString cis = new CaseInsensitiveString("Polish");
        String s = "polish";

        System.out.println(cis.equals(s));
        System.out.println(s.equals(cis));
    }
}
