import java.util.*;

// Czy widzisz "wyciek pamici"?
public class Stack {
    private Object[] elements;
    private int size = 0;

    public Stack(int initialCapacity) {
        this.elements = new Object[initialCapacity];
    }

    public void push(Object e) {
        ensureCapacity();
        elements[size++] = e;
    }

    public Object pop() {
        if (size==0)
            throw new EmptyStackException();
        Object result = elements[--size];
        elements[size] = null; // usunicie niepotrzebnej referencji
        return result;
    }

    /**
     * Zapewnienie miejsca na co najmniej jeden element, zwikszajc 
     * dwukrotnie za kadym razem, gdy tablica musi by powikszona.
     */
    private void ensureCapacity() {
        if (elements.length == size) {
            Object[] oldElements = elements;
            elements = new Object[2 * elements.length + 1];
            System.arraycopy(oldElements, 0, elements, 0, size);
        }
    }

    public static void main(String[] args) {
        Stack s = new Stack(0);
        for (int i=0; i<args.length; i++)
            s.push(args[i]);
        for (int i=0; i<args.length; i++)
            System.out.println(s.pop());
    }
}
