import java.util.*;
import java.io.*;

public class MutablePeriod {
    // Obiekt Period
    public final Period period;

    // Pole pocztkowe obiektu, do ktrego nie moemy mie dostpu
    public final Date start;

    // Pole kocowe obiektu, do ktrego nie moemy mie dostpu
    public final Date end;

    public MutablePeriod() {
        try {
            ByteArrayOutputStream bos =
                new ByteArrayOutputStream();
            ObjectOutputStream out =
                new ObjectOutputStream(bos);

            // Serializacja prawidowego obiektu Period
            out.writeObject(new Period(new Date(), new Date()));

            /*
             * Doczenie wrogich "poprzednich referencjiobiektw" do wewntrznych
             * pl Date w obiekcie Period. Wicej informacji w "Java 
             * Object Serialization Specification," Cz 6.4.
             */
            byte[] ref = { 0x71, 0, 0x7e, 0, 5 }; // Ref #5
            bos.write(ref); // Pole start
            ref[4] = 4;     // Referencja nr 4
            bos.write(ref); // Pole end

            // Deserializacja obiektu Period i "skradzionych referencji Date
            ObjectInputStream in = new ObjectInputStream(
            new ByteArrayInputStream(bos.toByteArray()));
            period = (Period) in.readObject();
            start  = (Date)   in.readObject();
            end    = (Date)   in.readObject();
        } catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void main(String[] args) {
        MutablePeriod mp = new MutablePeriod();
        Period p = mp.period;
        Date pEnd = mp.end;

        // Cofamy zegar
        pEnd.setYear(78);
        System.out.println(p);

        // Wracamy do lat szedziesitych!
        pEnd.setYear(69);
        System.out.println(p);
    }
}
