// Serializowalna podklasa nieserializowalnej klasy ze stanem

import java.io.*;

public class Foo extends AbstractFoo implements Serializable {
    private void readObject(ObjectInputStream s)
            throws IOException, ClassNotFoundException {
        s.defaultReadObject();

        // Rczna deserializacja i inicjalizacja stanu klasy bazowej
        int x = s.readInt();
        int y = s.readInt();
        initialize(x, y);
    }

    private void writeObject(ObjectOutputStream s)
            throws IOException {
        s.defaultWriteObject();

        // Rczna serializacja stanu klasy bazowej
        s.writeInt(getX());
        s.writeInt(getY());
    }

    // Konstruktor nie wykorzystuje adnego z dodatkowych mechanizmw
    public Foo(int x, int y) { super(x, y); }
}
