// Nieserializowalna klasa ze stanem umozliwiajca serializacj kals pochodnych
public abstract class AbstractFoo {
    private int x, y; // Stan
    private boolean initialized = false;

    public AbstractFoo(int x, int y) { initialize(x, y); }

    /**
     * Konstruktor ten i nastpna metoda pozwala 
     * metodzie readObject z klasie pochodnej zainicjowa stan wewntrzny.
     */
    protected AbstractFoo() { }

    protected final void initialize(int x, int y) {
        if (initialized)
            throw new IllegalStateException(
                "Ju zainicjowane");
        this.x = x;
        this.y = y;
        // ... Wykonanie pozostaych czynnoci wykonywanych przez oryginalny konstruktor
        initialized = true;
    }

    /**
     * Metody te zapewniaj dostp do wewntrznego stanu obiektu 
     * wic mog by serializowane przez metod writeObject z klasy pochodnej.
     */
    protected final int getX() { return x; }
    protected final int getY() { return y; }

    // Musi by wywoywana przez wszystkie publiczne metody
    private void checkInit() throws IllegalStateException {
        if (!initialized)
            throw new IllegalStateException("Niezainicjowane");
    }
    // ... // Pozosta cz pominita
}
