// Typ wyliczeniowy

import java.util.*;

public class Suit implements Comparable {
    private final String name;

    // Numer kolejny tworzonego koloru
    private static int nextOrdinal = 0;

    // Przypisanie numeru kolejnego do koloru
    private final int ordinal = nextOrdinal++;

    private Suit(String name) { this.name = name; }

    public String toString()  { return name; }

    public int compareTo(Object o) {
        return ordinal - ((Suit)o).ordinal;
    }

    public static final Suit CLUBS    = new Suit("clubs");
    public static final Suit DIAMONDS = new Suit("diamonds");
    public static final Suit HEARTS   = new Suit("hearts");
    public static final Suit SPADES   = new Suit("spades");

    // Eksportowanie staych
    private static final Suit[] PRIVATE_VALUES = 
        { CLUBS, DIAMONDS, HEARTS, SPADES };
    public static final List VALUES =
        Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));
}
