// Czste zastosowanie publicznej statycznej klasy zagniedonej
public class Calculator {
   public static abstract class Operation {
      private final String name;

      Operation(String name)   { this.name = name; }

      public String toString() { return this.name; }

      // Wykonanie operacji matematycznych okrelanych przez kontekst
      abstract double eval(double x, double y);

      // Dwukrotnie zagniedone klasy anonimowe
      public static final Operation PLUS = new Operation("+") {
         double eval(double x, double y) { return x + y; }
      };
      public static final Operation MINUS = new Operation("-") {
         double eval(double x, double y) { return x - y; }
      };
      public static final Operation TIMES = new Operation("*") {
         double eval(double x, double y) { return x * y; }
      };
      public static final Operation DIVIDE = new Operation("/") {
         double eval(double x, double y) { return x / y; }
      };
   }

   // Zwraca wynik wybranej operacji
   public double calculate(double x, Operation op, double y) {
      return op.eval(x, y);
   }
}
