// Dodanie atrybutu bez naruszania zaoe metody equals
public class ColorPoint2 {
    private Point point;
    private Color color;

    public ColorPoint2(int x, int y, Color color) {
        point = new Point(x, y);
        this.color = color;
    }

    /**
     * Zwraca punkt odpowidajcy biecemu punktowi kolorowemu
     */
    public Point asPoint() {
        return point;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColorPoint2))
            return false;
        ColorPoint2 cp = (ColorPoint2)o;
        return cp.point.equals(point) && cp.color.equals(color);
    }

    // ...  // Pozostaa cz pominita

    public static void main(String[] args) {
        // Test symetrii
        Point p = new Point(1, 2);
        ColorPoint2 cp = new ColorPoint2(1, 2, Color.RED);
        System.out.println(p.equals(cp));
        System.out.println(cp.equals(p));
        System.out.println();

        // Test przechodnioci
        ColorPoint2 p1 = new ColorPoint2(1, 2, Color.RED);
        Point p2 = new Point(1, 2);
        ColorPoint2 p3 = new ColorPoint2(1, 2, Color.BLUE);
        System.out.println(p1.equals(p2));
        System.out.println(p2.equals(p3));
        System.out.println(p1.equals(p3));
    }
}
